//name diffuse_light
//vert
varying vec3 ecPos;
varying vec3 ecNormal;			
void main()
{	
	gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * gl_Vertex;
	gl_TexCoord[0].st = gl_MultiTexCoord0.ts;
	ecNormal = gl_NormalMatrix * gl_Normal;
	vec4 ecPos4 = gl_ModelViewMatrix * gl_Vertex;
	ecPos = ecPos4.xyz/ecPos4.w;
}

//frag
uniform sampler2D diffuseMap;
varying vec3 ecPos;
varying vec3 ecNormal;
vec3 ecEye;
vec3 ecLight;

float diffuse(int lightId)
{
	ecLight = gl_LightSource[lightId].position.xyz - ecPos;
	return max(0.2, dot(normalize(ecNormal), normalize(ecLight)));
}

void main()
{					
	ecEye = normalize(-ecPos);				
	gl_FragColor = diffuse(0) * texture2D(diffuseMap, gl_TexCoord[0].st);
}

