package pl.vorg.mowa.core.graphics;

/**
 * Klasa bazowa dla buforów z atrybutami opisującym wierzchołki. 
 * Nazwa JEST znaczaca i odpowiada za semantyke atrybutu!
 * Podstawowe to pos, normal, texCoord0. Reszta zalezy od tego czego potrzebuje urzytkownik. 
 * Gdzie to jest uzywane? Patrz Geometry.displayImmediately()
 * 
 * dataType - to powinno byc ustawione na ilosc elementow danego typu z ilu sklada sie atrybut 
 * np pozycja skladalaby sie z 3 liczba zmiennoprzecinkowych x,y,z, a wsporzedne tekstury z 2 s,t
 * mialo to byc wykorzystanw przy VertexArrays ale poniewaz nie dzialaja one w JOGL pod OSX 
 * te wartosci sa zahardkodowane w Geometry.displayImmediately() a dataType nie zostalo uzyte (a powinno) 
 * 
 * @author vorg
 */
public abstract class VertexAttrib {
	private String name = "";
	private int dataType;
	
	public VertexAttrib(String name) {
		this.name = name;
	}
	
	public int getDataType() {
		return dataType;
	}
	public void setDataType(int dataType) {
		this.dataType = dataType;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	
}
