//name fur
//vert
uniform float scale;
varying vec3 ecPos;
varying vec3 ecNormal;			
void main()
{	
	vec4 vert = gl_Vertex + vec4(gl_Normal.x*scale, gl_Normal.y*scale, gl_Normal.z*scale, 0);
	gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * vert;
	gl_TexCoord[0].st = gl_MultiTexCoord0.ts;
	gl_TexCoord[0].st *= 0.25;
	ecNormal = gl_NormalMatrix * gl_Normal;
	vec4 ecPos4 = gl_ModelViewMatrix * gl_Vertex;
	ecPos = ecPos4.xyz/ecPos4.w;
}

//frag
uniform sampler2D diffuseMap;
uniform sampler2D furMap;
varying vec3 ecPos;
varying vec3 ecNormal;
vec3 ecEye;
vec3 ecLight;

float diffuse(int lightId)
{
	ecLight = gl_LightSource[lightId].position.xyz - ecPos;
	return max(0.2, dot(normalize(ecNormal), normalize(ecLight)));
}

void main()
{					
	ecEye = normalize(-ecPos);	
	vec3 alpha = texture2D(furMap, vec2(gl_TexCoord[0].s * 2.0, gl_TexCoord[0].t * 2.0)).xyz;
	if (alpha.r + alpha.g + alpha.b < 1.5) discard;			
	gl_FragColor = diffuse(0) * texture2D(diffuseMap, gl_TexCoord[0].st);;
}

