package pl.vorg.mowa.core.graphics;

import java.util.ArrayList;

/**
 * Strumień wierzchołków. Każdy wierzchołek opisywany jest przez różne atrybuty (pozycja, kolor, wsporzedne tekstury,.. ) trzymane w buforach.
 * Za to jak kolejno ukladaja sie wiercholki odpowiada indexBuffer.
 * 
 * Np trojkat 
 * o wierzcholkach (0,0,0) (1,0,0) (0,1,0) 
 * o kolorach czerwonym, zielonym i niebieskim 
 * ze wspolrzednymi tekstury (0,0) (1,0) (0,1)
 * 
 * wygladalby tak
 * FloatVertexAttrib "pos"       : [0, 0, 0, 1, 0, 0, 0, 1, 0]  
 * FloatVertexAttrib "color"     : [1, 0, 0, 0, 1, 0, 0, 0, 1]
 * FloatVertexAttrib "texCoord0" : [0, 0, 1, 0, 0, 1]
 * IndexBuffer                   : [0, 1, 2]
 * 
 * @author vorg
 */
public class VertexStream {
	private ArrayList<VertexAttrib> attribs = new ArrayList<VertexAttrib>();
	private IndexBuffer indexBuffer;
	
	public ArrayList<VertexAttrib> getAttribs() {
		return attribs;
	}
	
	public VertexAttrib getAttribByName(String name) {
		for(VertexAttrib attrib : attribs) {
			if (attrib.getName().equals(name)) {
				return attrib;
			}
		}
		return null;
	}
	
	public void addAttrib(VertexAttrib attrib) {
		attribs.add(attrib);
	}

	public IndexBuffer getIndexBuffer() {
		return indexBuffer;
	}

	public void setIndexBuffer(IndexBuffer indexBuffer) {
		this.indexBuffer = indexBuffer;
	}
}
