package pl.vorg.mowa.core.graphics;


/**
 * Sześcian obejmujący obiekt w przestrzeni 3d
 * 
 * @author vorg
 */
public class BoundingBox {
	private Vec3 min;
	private Vec3 max;
	
	public BoundingBox() {
		empty();
	}
	
	public Vec3 getMax() {
		return max;
	}
	
	public void setMax(Vec3 max) {
		this.max = max;
	}
	
	public Vec3 getMin() {
		return min;
	}
	
	public void setMin(Vec3 min) {
		this.min = min;
	}
	
	public Vec3 getSize() {
		return Vec3.sub(max, min);
	}
	
	public void empty() {
		min = new Vec3(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
		max = new Vec3(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
	}
	
	public boolean isEmpty() {
		return (min.getX() > max.getX()) || (min.getY() > max.getY()) || (min.getZ() > max.getZ());
	}
	
	public void add(float x, float y, float z) {
		if (x < min.getX()) min.setX(x);
		if (y < min.getY()) min.setY(y);
		if (z < min.getZ()) min.setZ(z);
		if (x > max.getX()) max.setX(x);
		if (y > max.getY()) max.setY(y);
		if (z > max.getZ()) max.setZ(z);
	}
	
	public void add(Vec3 v) {
		add(v.getX(), v.getY(), v.getZ());
	}
	
	public void add(BoundingBox box) {
		add(box.getMin());
		add(box.getMax());		
	}
	
	
	
	@Override
	public String toString() {
		return "BoundingBox : min("+min.getX()+","+min.getY()+","+min.getZ()+") max("+max.getX()+","+max.getY()+","+max.getZ()+")";
	}
	
}
