package com.framsticks.net.client3D;

import javax.media.opengl.GL;

/**
 * Interfejs dla klas odpowiedzialnych za rozne style renderowania framstickow
 * @author vorg
 *
 */
public interface Style {
	/**
	 * Inicjalizacja. Tutaj styl powinien wgrac wszelkie potrzebne tekstury, shadery itp. 
	 * @param gl
	 */
	public void init(GL gl);
	
	/**
	 * Renderowanie stworow. Przekazujemy od razu cala tablice bo wszystkie framsticki maja jeden i ten sam styl
	 * @param gl
	 * @param creatures
	 * @param modelType
	 */
	public void render(GL gl, Creature[] creatures, Creature.ModelType modelType);
	
	/**
	 * Czy inicjalizacja sie powiodla
	 * @return true - tak, false - wystapil jakis blad i styl nie nadaje sie do uzyca
	 */
	public boolean isInitialized();
}
