//Typical load/save handling (intended for files with *.expt extension)

global expLoadGenePoolCounter, expLoadPopulationCounter; //only used when reading expt files

function onExpLoad()
{
  for (var pool in GenePools)
      pool.clear();
  for (var pop in Populations)
      pop.clear();

  expLoadGenePoolCounter = -1; //will be incremented on read
  expLoadPopulationCounter = -1; //will be incremented on read

  Loader.addClass(sim_params.*);
  Loader.addClass(Population.*);
  Loader.addClass(GenePool.*);
//  Loader.setBreakLabel(Loader.OnComment, "onExpLoad_Comment");
  Loader.setBreakLabel(Loader.BeforeObject, "onExpLoad_Object");
  Loader.setBreakLabel(Loader.BeforeUnknown, "onExpLoad_Unknown");
  Loader.run();

  if (expLoadGenePoolCounter < GenePools.size - 1)
    Simulator.message("onExpLoad(): not enough gene pool settings in input file: found " + (expLoadGenePoolCounter + 1) + ", expected " + GenePools.size, 1);
  if (expLoadPopulationCounter < Populations.size - 1)
    Simulator.message("onExpLoad(): not enough population settings in input file: found " + (expLoadPopulationCounter + 1) + ", expected " + Populations.size, 1);

  var loaded = 0;
  for (var pool in GenePools)
    loaded += pool.size;
  if (loaded > 0)
    Simulator.print("Experiment loaded (" + loaded + " genotypes)");
}

function loadOrSkipObject()
{
  // return 1=>obj should be loaded, 0=>skip this obj, -1=>do nothing (already handled)

  switch (Loader.objectName)
  {
  case "Population":
    expLoadPopulationCounter++;
    if (expLoadPopulationCounter >= Populations.size)
    {
      Simulator.message("onExpLoad(): too many populations in input file: expected " + Populations.size, 2);
      return 0;
    }
    else
    {
      Loader.currentObject = Populations[expLoadPopulationCounter];
      return 1;
    }

  case "GenePool":
    expLoadGenePoolCounter++;
    if (expLoadGenePoolCounter >= GenePools.size)
    {
      Simulator.message("onExpLoad(): too many gene pools in input file: expected " + GenePools.size, 2);
      return 0;
    }
    else
    {
      Loader.currentObject = GenePools[expLoadGenePoolCounter];
      return 1;
    }
  }

  return -1;
}

function onExpLoad_Unknown()
{
  switch (Loader.objectName)
  {
  case "org":
    Loader.currentObject = Genotype.newFromString("");
    Interface.makeFrom(Loader.currentObject).setAllDefault();
    Loader.loadObject();
    if (expLoadGenePoolCounter >= GenePools.size)
      Simulator.message("onExpLoad(): skipping genotype " + Loader.currentObject.name + " belonging to superfluous gene pool", 2);
    else
      Loader.currentObject.copyTo(GenePools[Math.max(0,expLoadGenePoolCounter)]);
    break;

  case "CreaturesGroup":
    Loader.objectName = "Population";
    Simulator.message("'CreaturesGroup' found in experiment settings file, please change to 'Population'", 1);
    if (loadOrSkipObject() == 1) //for unknown the default action is to skip, so we force load when == 1
      Loader.loadObject();
    break;

  case "GenotypeGroup":
    Loader.objectName = "GenePool";
    Simulator.message("'GenotypeGroup' found in experiment settings file, please change to 'GenePool'", 1);
    if (loadOrSkipObject() == 1) //for unknown the default action is to skip, so we force load when == 1
      Loader.loadObject();
    break;
  }
}

function onExpLoad_Object()
{
  if (loadOrSkipObject() == 0) //for known object the default action is to load, so we force skip when == 0
    Loader.skipObject();
}

function onExpSave()
{
  var saved_genotypes = 0;

  File.writeComment("saved by 'standard_loadsave.inc'");
  File.writeObject(sim_params.*);

  for (var gp in GenePools)
  {
    File.writeObject(gp);
    for (var g in gp)
    {
      File.writeNameObject("org", g);
      saved_genotypes++;
    }
  }

  for (var pop in Populations)
    File.writeObject(pop);

  Simulator.print("Experiment saved (" + saved_genotypes + " genotypes)");
}

