global g_helptxt;
global g_iconbuttons;
global g_subMenuHiding;
global _saved_criterion;
global _saved_water;

function initialGenotype()
{
return "RcqXXX(ddGGbbXX,DDggbbX)";
}

function loadCurrent()
{
GenePools[0].clear();
Simulator.import("scripts_output"+File.pathseparator+"mobi-current.gen");
if (GenePools[0].size==0)
   GenePools[0].add(initialGenotype());
}

function saveCurrent()
{
Simulator.export("mobi-current.gen",2,0,0);
}

function loadHistory()
{
GenePools[0].clear();
Simulator.import("scripts_output"+File.pathseparator+"mobi-history.gen");
}

function saveHistory()
{
Simulator.export("mobi-history.gen",2,0,0);
}

function addHistory(genotype,velocity,height)
{
loadHistory();
if (GenePools[0].size>49)
   GenePools[0][0].delete();
var g=GenePools[0].add(genotype);
g.velocity=velocity;
g.vertpos=height;
g.user1=Math.time;
saveHistory();
}

function ALsharedResetGUI()
{
g_iconbuttons=null;
g_subMenuHiding=null;
}

function addIconButton(but,size,x,y)
{
if (g_iconbuttons==null)
  g_iconbuttons=[];
g_iconbuttons.add([but,float(size),float(x),float(y)]);
}

function addHelpButton(xposition)
{
var but=GUI.newButton("helpbut","");
but.style=1;
but.image="info-icon-shadow";
addIconButton(but,0.15,xposition,0);
layoutIconButtons();
}

function handleHelp(elem)
{
if (String.startsWith(elem.name,"help"))
   {
   if (GUI["help"])
      {
      GUI.removeElement("help");
      }
   else
      {
      var h=GUI.newBubble("help",g_helptxt);
      h.addTo(GUI["helpbut"]);
      h.setAutolayout(0,0,0,0, 0,0,1,1);
      }
   return 1;
   }
return 0;
}

function layoutIconButtons()
{
if (g_iconbuttons==null) return;
for (var b in g_iconbuttons)
  {
  var s=Math.min(b[1]*GLDisplay.size_x,b[1]*GLDisplay.size_y);
  var but=b[0];
  var r=Rectangle.newFromXYWH(b[2]*(float(GLDisplay.size_x)-s),b[3]*(float(GLDisplay.size_y)-s),s,s);
  but.rect=r;
  }
}

function subMenuHidingFinished()
{
for(var sub in g_subMenuHiding)
    sub.visible=0;
g_subMenuHiding=null;
GUI.setTimeout("subhide",0,null);
}

function handleSubMenu(elem,menu,dir,w,h)
{
  if (g_subMenuHiding)
     subMenuHidingFinished();
  var show=!elem.selected;
  elem.selected=show;
  var t=0.2;
  if (show)
  {
    t+=0.1*menu.size;
    var begin=elem.rect;
    var end=elem.rect;
    end.width=w*GLDisplay.size_x; end.height=h*GLDisplay.size_y;
    if (end.x+end.width>GLDisplay.size_x) end.x=float(GLDisplay.size_x)-end.width;
    var dy;
    if (dir==1) end.y+=end.height;
    end.height*=0.8;
    if (dir==1) { dy=end.height; end.y-=dy; }
    if (dir==0) dy=-end.height;
    for(var sub in menu)
    {
      end.y+=dy;
      sub.visible=1;
      sub.rect=begin;
      sub.animSetBegin();
      sub.setAutolayout(0,0,0,0, end.x/GLDisplay.size_x,end.y/GLDisplay.size_y,end.width/GLDisplay.size_x,end.height/GLDisplay.size_y);
      sub.rect=end;
      sub.animSetEnd();
      sub.startAnimation(t);
      t-=0.1;
    }
  }
  else
  {
    for(var sub in menu)
    {
      sub.animSetBegin();
      sub.rect=elem.rect;
      sub.animSetEnd();
      sub.startAnimation(t);
      t+=0.2;
    }
    g_subMenuHiding=menu;
    GUI.setTimeout("subhide",t/2,function subMenuHidingFinished);
  }
}
