import java.awt.*;
import java.util.Hashtable;
import java.util.Vector;
import java.util.ArrayList;
import java.util.Enumeration;
import java.lang.String;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;


class DataComponents {
    private static Font font, fontBold, fontSmall, system, control, fontTip;
    private static Color color1, color2;
    private static Border compound, lowEtached, compound1;

    DataComponents(){
        InitFonts();
    }
    
//================================================================================    
//              INITIALIZE FONTS 
//================================================================================    
    private void InitFonts(){
        font = new Font("Arial", Font.PLAIN, 11);
        fontBold = new Font("Arial", Font.BOLD, 11);
        fontSmall = new Font("Arial", Font.PLAIN, 10);
        system = new Font("Arial", Font.PLAIN, 12);
        control = new Font("Arial", Font.BOLD, 12);
        fontTip = new Font("Arial", Font.PLAIN, 9);
        color1 = new Color(102,102,153);
        color2 = new Color(204,204,255);
        compound = BorderFactory.createCompoundBorder(
                        BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(204,204,255)),
                        BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        compound1 = BorderFactory.createCompoundBorder(
                        BorderFactory.createEtchedBorder(EtchedBorder.LOWERED),
                        BorderFactory.createEmptyBorder(2,2,2,2));
        lowEtached = BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
    }
//================================================================================    
//              INITIALIZE JLabel 
//================================================================================     
    public JLabel InitLabel(String Name){
        JLabel label = new JLabel(Name);
        //label.setFont(fontBold);
        label.setForeground(color1);
    return label;    
    }
//================================================================================    
//              INITIALIZE JButton 
//================================================================================     
    public JButton InitButton(String ID, String Name, Hashtable values, Hashtable help){
        JButton button = new JButton(" "+Name+" ");
        button.setName(ID);
        button.setForeground(Color.black);
        button.setBackground(color2);
        //button.setBorder(lowered);
        //button.setMinimumSize(new Dimension(Integer.MAX_VALUE, 20));
        //button.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        button.setHorizontalAlignment(JButton.CENTER);
        button.setAlignmentY(Component.CENTER_ALIGNMENT);
        
        String tip = new String("<html><p>");
        if(help.containsKey(ID)){
            ArrayList hList = (ArrayList) help.get(ID);
            for (int i=0; i<hList.size();i++){
                tip=tip+hList.get(i);
                tip=tip+"</p><p>";
            } 
        }
        button.setToolTipText(tip+"</p></html>");
    return button;    
    }    
//================================================================================    
//              INITIALIZE JCheckBox 
//================================================================================     
    public JCheckBox InitCheckBox(String ID, String Name, Hashtable values, Hashtable help){
        JCheckBox checkBox = new JCheckBox(Name);
        checkBox.setName(ID);
        checkBox.setForeground(color1);
        
        String tip = new String("<html>");
        if(help.containsKey(ID)){
            ArrayList hList = (ArrayList) help.get(ID);
            for (int i=0; i<hList.size();i++){
                tip=tip+hList.get(i);
                tip=tip+"</p><p>";
            } 
        }
        checkBox.setToolTipText(tip+"</p></html>");
        boolean b = false;
        if(values.containsKey(ID)){
            ArrayList vList = (ArrayList) values.get(ID);
            if ((vList.get(0)).equals("1")){b=true;}
            else {b=false;}
        } 
        checkBox.setSelected(b);
        checkBox.setToolTipText(tip);
    return checkBox;    
    }    
    
//================================================================================    
//              INITIALIZE JTextArea 
//================================================================================     
    public JTextArea InitTextArea(String ID, Hashtable values, Hashtable help){
        JTextArea textA = new JTextArea();
        textA.setName(ID);
        textA.setBorder(compound);
        textA.setLineWrap(true);
        textA.setWrapStyleWord(true); 
        
        
        String tip = new String("<html><p>");
        if(help.containsKey(ID)){
            ArrayList hList = (ArrayList) help.get(ID);
            for (int i=0; i<hList.size();i++){
                tip=tip+hList.get(i);
                tip=tip+"</p><p>";
            } 
        }
        textA.setToolTipText(tip+"</p></html>");
        
        if(values.containsKey(ID)){
           ArrayList vList = (ArrayList) values.get(ID);
           for(int i=0; i<vList.size(); i++){
                textA.append(" "+vList.get(i)+"\n");
            }
        }
        
    return textA;    
    } 
//================================================================================    
//              INITIALIZE JTextField 
//================================================================================     
    public JTextField InitTextField(String ID, Hashtable values, Hashtable help){
        
        JTextField text = new JTextField();
        text.setName(ID);
        text.setHorizontalAlignment(JTextField.CENTER);
        text.setBorder(compound);
        text.setAlignmentY(Component.CENTER_ALIGNMENT);
        
        String tip = new String("<html><p> ");
        if(help.containsKey(ID)){
            ArrayList hList = (ArrayList) help.get(ID);
            for (int i=0; i<hList.size();i++){
                tip=tip+hList.get(i);
                tip=tip+" </p><p> ";
            } 
        }
        text.setToolTipText(tip+" </p></html>");
        
        if(values.containsKey(ID)){
            ArrayList vList = (ArrayList) values.get(ID);
            text.setText((vList.get(0)).toString());
        }

    return text;    
    }      

//================================================================================    
//              INITIALIZE JComboBox 
//================================================================================     
    public JComboBox InitComboBox(String ID, Vector v, String type, Hashtable values, Hashtable help){
        
        JComboBox comboBox = new JComboBox(v);
        comboBox.setName(ID);
        comboBox.setAlignmentY(Component.CENTER_ALIGNMENT);
        comboBox.setBackground(color2);
        comboBox.setLightWeightPopupEnabled(true);
        
        String tip = new String("<html><p> ");
        if(help.containsKey(ID)){
            ArrayList hList = (ArrayList) help.get(ID);
            for (int i=0; i<hList.size();i++){
                tip=tip+hList.get(i);
                tip=tip+" </p><p> ";
            } 
        }
        
        comboBox.setToolTipText(tip+" </p></html>");
        
        String selected = new String();
        if(values.containsKey(ID)){
            ArrayList vList = (ArrayList) values.get(ID);
            selected = (vList.get(0)).toString();
        }
        if(!selected.equals("")){
            if(type.equals("d")){
                    comboBox.setSelectedIndex(Integer.parseInt(selected));
                }
            else if(type.equals("s")){
                    comboBox.setSelectedItem(selected);
                }
        }
    return comboBox;    
    }  
//================================================================================    
//              INITIALIZE JSlider 
//================================================================================     
    public JSlider InitSlider(String ID, String type, Hashtable values, Hashtable help){
               
        String [] a = type.split(" ");
        
        int MIN = Integer.parseInt(a[1]);
        int MAX = Integer.parseInt(a[2]);
        int POS = 0;
        
        if(values.containsKey(ID)){
            ArrayList vList = (ArrayList) values.get(ID);
            POS = Integer.parseInt((vList.get(0)).toString());
        }
               
        JSlider slider = new JSlider(MIN, MAX, POS);
        slider.setName(ID);
        slider.setMajorTickSpacing (MAX/4);
        slider.setPaintTicks (true);
        slider.setMinorTickSpacing ((MAX/4)/2);
        slider.setPaintLabels (true);
        slider.setBackground(color2);
        slider.setBorder(lowEtached);
        slider.putClientProperty("JSlider.isFilled", new Boolean(true));

     
        String tip = new String("<html><p> ");
        if(help.containsKey(ID)){
            ArrayList hList = (ArrayList) help.get(ID);
            for (int i=0; i<hList.size();i++){
                tip=tip+hList.get(i);
                tip=tip+" </p><p> ";
            } 
        }
        slider.setToolTipText(tip+" </p></html>");
        
    return slider;    
    } 
    
    
//================================================================================    
//              CONNECT DIALOG 
//================================================================================     
    
}