/* 
 * (C) Poznan University of Technology
 * File name: VectorMath.java.
 * Created on 2004-02-05 10:51:57.
 */
package frams_client_3d;

/**
 * Three dimensional vectors class.
 * @author <a href="mailto:momat@man.poznan.pl">MoMaT</a>
 */
public class Vector3D {

	private float[] v = {0, 0, 0};
	
	/**
	 * Default parametrized constructor.
	 * @param vx vector x coordinate
	 * @param vy vector y coordinate
	 * @param vz vector z coordinate
	 */
	public Vector3D(float vx, float vy, float vz) {
		v[0] = vx;
		v[1] = vy;
		v[2] = vz;					
	}
	/**
	 * Defualt parametrized constructor.
	 * @param vector an array of vector coordinates
	 */
	public Vector3D(float[] vector) {
		v = vector;					
	}
	/**
	 * Copy constructor. 
	 * @param vector 3D vector object
	 */
	public Vector3D(Vector3D vector) {
		float[] w = vector.getVector();
		v[0] = w[0];
		v[1] = w[1];
		v[2] = w[2];					
	}
	/**
	 * Vector3D getter.
	 * @return an array of vector coordinates
	 */
	public float[] getVector() {
		return v;
	}				
	/**
	 * Rotates the vector around an axis about an angle. 
	 * @param angle a rotation angle
	 * @param axis a rotation axis vector
	 */
	public void rotate(float angle, Vector3D axis)
	{		
		float cos = (float)Math.cos(angle);
		float sin = (float)Math.sin(angle);
		float[] r = new float[3];	
		float[] a = axis.getVector();

		r[0] = (cos+(1-cos)*a[0]*a[0])*v[0];
		r[0] += ((1-cos)*a[0]*a[1]-a[2]*sin)*v[1];
		r[0] += ((1-cos)*a[0]*a[2]+a[1]*sin)*v[2];

		r[1] = ((1-cos)*a[0]*a[1]+a[2]*sin)*v[0];
		r[1] += (cos+(1-cos)*a[1]*a[1])*v[1];
		r[1] += ((1-cos)*a[1]*a[2]-a[0]*sin)*v[2];
		
		r[2] = ((1-cos)*a[0]*a[2]-a[1]*sin)*v[0];
		r[2] += ((1-cos)*a[1]*a[2]+a[0]*sin)*v[1];
		r[2] += (cos+(1-cos)*a[2]*a[2])*v[2];
		
		v = r;				
	}	
	/**
	 * Calculates the cross product of two vectors.
	 * @param vector
	 * @return plane normal vector
	 */
	public void vectorProduct(Vector3D vector)
	{
		float w[] = vector.getVector();
		float p[] = new float[3];

		p[0] = v[1]*w[2]-v[2]*w[1];
		p[1] = v[2]*w[0]-v[0]*w[2];
		p[2] = v[0]*w[1]-v[1]*w[0];
		
		v = p;
	}	
	/**
	 * Normalize a vector.
	 * @return normalized vector
	 */
	public void normalize()
	{					
		float length = this.length();
		v[0] /= length;
		v[1] /= length;
		v[2] /= length;		 				                                                       	
	}	
	/**
	 * Calculates the length of the vector.
	 * @return vector length
	 */
	public float length() {	
		return (float)Math.sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]);
	}
	/**
	 * Calculates the dot product with given vector.
	 * @param vector
	 * @return scalar quantity
	 */
	public float scalarProduct(Vector3D vector)
	{				
		float[] w = vector.getVector();
		return v[0]*w[0]+v[1]*w[1]+v[2]*w[2];
	}	
	/**
	 * Multiply the vector by a scalar.
	 * @param scalar
	 */
	public void mult(float scalar) {
		v[0] *= scalar;
		v[1] *= scalar;
		v[2] *= scalar;
	}
}
