/* 
 * (C) Poznan University of Technology
 * File name: Log.java.
 * Created on 2004-01-24 15:42:05.
 */
package frams_client_3d;

import java.awt.Color;
import java.awt.Insets;

import javax.swing.JFrame;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

/**
 * Network communication log frame class.
 * @author <a href="mailto:momat@man.poznan.pl">MoMaT</a>
 */
public class Log extends JFrame {

	private javax.swing.JPanel jContentPane = null;

	private javax.swing.JScrollPane jScrollPane = null;
	private javax.swing.JTextPane jTextPane = null;
	
	private javax.swing.text.StyledDocument doc = null;
	private javax.swing.text.SimpleAttributeSet defaultAttributeSet = null;

	static public int RED = 0;
	static public int ORANGE = 1;
	static public int GREEN = 2;
	static public int BLUE = 3;
	static public int BLACK = 4;
		
	/**
	 * This is the default constructor
	 */
	public Log() {
		super();
		initialize();
		setDefaultCloseOperation(HIDE_ON_CLOSE);
	}
	/**
	 * This method initializes this
	 * @return void
	 */
	private void initialize() {
		this.setSize(450, 300);
		this.setContentPane(getJContentPane());
		this.setTitle("Frams Client 3D - network log");
	}
	/**
	 * This method initializes jContentPane 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new javax.swing.JPanel();
			jContentPane.setLayout(new java.awt.BorderLayout());
			jContentPane.add(getJScrollPane(), java.awt.BorderLayout.CENTER);
		}
		return jContentPane;
	}
	/**
	 * This method initializes jScrollPane
	 * @return javax.swing.JScrollPane
	 */
	private javax.swing.JScrollPane getJScrollPane() {
		if(jScrollPane == null) {
			jScrollPane = new javax.swing.JScrollPane();
			jScrollPane.setViewportView(getJTextPane());
			jScrollPane.setWheelScrollingEnabled(true);			
		}
		return jScrollPane;
	}
	/**
	 * This method initializes jTextPane 
	 * @return javax.swing.JTextPane
	 */
	private javax.swing.JTextPane getJTextPane() {
		if(jTextPane == null) {
			jTextPane = new javax.swing.JTextPane();
			jTextPane.setMargin(new Insets(0,5,0,5));
			jTextPane.setEditable(false);
			
			doc = jTextPane.getStyledDocument();
			defaultAttributeSet = new SimpleAttributeSet();
			StyleConstants.setFontFamily(defaultAttributeSet, "Monospaced");
			StyleConstants.setFontSize(defaultAttributeSet, 11);
		}
		return jTextPane;
	}
	/**
	 * Adds a new line to the log.
	 * @param line line text
	 * @param color line color
	 */
	public void addLogLine(String line, Color color) {
		SimpleAttributeSet set = new SimpleAttributeSet(defaultAttributeSet);
		StyleConstants.setForeground(set, color);					
		try {
			doc.insertString(doc.getLength(), line+"\n", set);
		} catch (BadLocationException e) {
			e.printStackTrace();
			System.exit(-1);
		}
	}
}