/* 
 * (c) Poznan University of Technology
 * File name: Communication.java.
 * Created on 2003-10-04 21:51:59.
 */
 
package frams_client_3d;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;

/**
 * Communication class.
 * @author <a href="mailto:momat@man.poznan.pl">MoMaT</a>
 */
public class Communication {
	private Socket socket = null;
	private PrintWriter out = null;
	private BufferedReader in = null;

	private ArrayList log = new ArrayList();
	 	
	/**
	 * Connect to a server.
	 * @param ip
	 * @param port
	 * @throws IOException Thrown on I/O error.
	 */	
	public void connect(String ip, int port) throws IOException {										
		socket = new Socket(ip, port);
		out = new PrintWriter(socket.getOutputStream(), true);
		in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
		
		//choose protocol version	
		sendMessage("version 2");
		String message = in.readLine();
		log.add("> " + message);
	}
	/**
	 * Close connection.
	 * @throws IOException Thrown on socket close error.
	 */
	public void disconnect() throws IOException {	
		out.close();
		in.close();
		socket.close();
	}				
	/**
	 * Read a server response.
	 * @return server answer
	 * @throws IOException Thrown on read error.
	 * @throws InterruptedException Thrown on thread sleep interruption.
	 * @throws CommunicationErrorException Thrown on protocol error.
	 */
  	public ArrayList readMessage()
  	throws IOException, InterruptedException, CommunicationErrorException {		
	  	String message = null;
		ArrayList buffer = new ArrayList();

		//gentle wait for input on socket
		while (false == in.ready()) {
			Thread.sleep(100);				
		}
	  	//read server answer			
	  	while ((message = in.readLine()) != null) {				
			log.add("> " + message);
			//stop if reading complete
			if(message.startsWith("ok")) {
				//add ok line if it contains additional info
				if (3 < message.length()) {
					buffer.add(message);
				}				
				break;
			} else if (message.startsWith("error")) {
				String error = message.substring(message.indexOf(' '));
				throw new CommunicationErrorException(error);
	  		}				
			buffer.add(message);					
		}
		return buffer;
  	}										  																																			
	/**
	 * Send request to a server. 
 	 * @param message
 	 */
	public void sendMessage(String message) {		
		out.println(message);
		log.add(message);			
	}			
	/**
	 * Log getter.
	 * @return log array
	 */
	public ArrayList getLog() {
		return log;
	}
}
