import java.awt.*;
import java.awt.event.*;
import java.util.Hashtable;
import java.util.Vector;
import java.util.ArrayList;
import java.util.Enumeration;
import java.lang.String;
import java.io.IOException;
import javax.swing.*;
import javax.swing.JPanel;
import javax.swing.tree.*;
import javax.swing.event.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.border.EtchedBorder; 
import java.net.SocketException;
import javax.swing.text.StyledDocument;
import javax.swing.text.SimpleAttributeSet;


public class FClient extends JPanel implements ActionListener, ChangeListener, KeyListener{
    
    private Server server;
    private Parser parser;
    private DataComponents dataComp;

    private JTextField statusBar, IPtext, PORTtext, input;
    private JLabel statusLabel, label1, label2, treeLabel, dataLabel;
    private DynamicTree treePanel;
    private Hashtable hashTable;
    private JPanel DataPanel, TreePanel;
    private JFrame frame, frameLog;
    private JButton but, butLog;
    private JTextArea logPane, eventPane;
    private Thread thread;
    private static Font font, fontBold, fontSmall, system, control, fontTip;
    private static Color color1, color2;
    private Border lowEtached, empty, loweredBevel, lowered, compound;
    boolean threadSuspended = false;
    private StyledDocument doc = null;
    private SimpleAttributeSet defaultAttributeSet = null;
  
    public FClient(){
        super(new BorderLayout());
        InitFonts();
        
        //Container for tree
        TreePanel = new JPanel(new BorderLayout());
        treeLabel = new JLabel("Framsticks Server", JLabel.CENTER);
        treeLabel.setFont(new Font("Arial", Font.BOLD, 14));
        treeLabel.setForeground(color1);
        treeLabel.setBorder(empty);
        TreePanel.add(treeLabel, BorderLayout.NORTH);
        
        //
        JPanel EventLog = new JPanel(new GridLayout(1,0));
        eventPane = new JTextArea();
        JScrollPane eventScrollPane = new JScrollPane(eventPane);
        EventLog.add(eventScrollPane);
        
        //Split pane for TreePanel and EventLog       
        JSplitPane splitPaneV = new JSplitPane(JSplitPane.VERTICAL_SPLIT,TreePanel, EventLog);
        splitPaneV.setOneTouchExpandable(true);
        splitPaneV.setDividerLocation(400);
        splitPaneV.setBorder(compound);
        
        //Container for object attributes
        JPanel dataPanel = new JPanel(new BorderLayout());
        DataPanel = new JPanel();
        JScrollPane dataScrollPane = new JScrollPane(DataPanel);
        dataLabel = new JLabel("Class: ",JLabel.CENTER);
        dataLabel.setFont(new Font("Arial", Font.BOLD, 14));
        dataLabel.setForeground(color1);
        dataLabel.setBorder(empty);
        dataPanel.add(dataLabel, BorderLayout.NORTH);
        dataPanel.add(dataScrollPane, BorderLayout.CENTER);
        
        //Menu
        JPanel menuPanel = new JPanel(new GridLayout(2,0,10,10));
        menuPanel.setBorder(empty);
        JMenuBar menuBar;
        JMenu menu;
        JMenuItem menuItem;
        menuBar = new JMenuBar();    
                
        menu = new JMenu("Tools");
        menu.setMnemonic(KeyEvent.VK_T);
        menuBar.add(menu);
        
        menuItem = new JMenuItem("Connect", KeyEvent.VK_O);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        
        menuItem = new JMenuItem("Disconnect", KeyEvent.VK_D);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator(); 
        
        menuItem = new JMenuItem("Console", KeyEvent.VK_L);
        menuItem.addActionListener(this);
        menu.add(menuItem);    
        
        menu = new JMenu("Help");
        menu.setMnemonic(KeyEvent.VK_H);
        menuBar.add(menu);
        
        menuItem = new JMenuItem("About", KeyEvent.VK_A);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        
        menuPanel.add(menuBar);
        //Box boxx = Box.createHorizontalBox();            
        //menuPanel.add(boxx);
        //statusLabel = new JLabel("Status", JLabel.CENTER);
        //statusLabel.setFont(font);
        //label1 = new JLabel("1", JLabel.CENTER);
        //label1.setFont(font);
        //label2 = new JLabel("2", JLabel.CENTER);
        //label2.setFont(font);
        //boxx.add(statusLabel);
        //boxx.add(Box.createRigidArea(new Dimension(15,0)));
        //boxx.add(label1);
        //boxx.add(Box.createRigidArea(new Dimension(15,0)));
        //boxx.add(label2);
        //boxx.add(Box.createRigidArea(new Dimension(15,0)));
        
                  
        //Split pane for TreePanel and dataPanel       
        JSplitPane splitPaneH = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,splitPaneV, dataPanel);
        splitPaneH.setOneTouchExpandable(true);
        splitPaneH.setDividerLocation(300);
        splitPaneH.setBorder(compound);
        
        //StatusBar
        statusBar = new JTextField();
        compound = BorderFactory.createCompoundBorder(empty,loweredBevel);
        statusBar.setBorder(compound);
        statusBar.setEditable(false);
 
        //Adds to main window
        add(menuPanel, BorderLayout.NORTH);
        add(splitPaneH, BorderLayout.CENTER);
        add(statusBar, BorderLayout.SOUTH);
        
        hashTable = new Hashtable();
        server = new Server();
        parser = new Parser();
        dataComp = new DataComponents();
        
        setConnectDialog();
        setLog();
        thread = new myThread();
        
        //main window size
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension s = toolkit.getScreenSize();
        setPreferredSize(new Dimension(800, 600));       
}   
//================================================================================    
//              TREE PANEL INITIATE 
//================================================================================     
    private void setTreePanel(){
        treePanel = new DynamicTree();
        TreePanel.add(treePanel, BorderLayout.CENTER);
        TreePanel.revalidate();
        TreePanel.repaint();
    }
//================================================================================    
//              CONNECT DIALOG INITIALIZE
//================================================================================     
    private void setConnectDialog(){
        JPanel pane = new JPanel(new GridLayout(3,3));
        pane.setBorder(empty);
        JLabel ip = new JLabel("IP ", JLabel.RIGHT);
        ip.setForeground(color1);
        JLabel port = new JLabel("Port ", JLabel.RIGHT);
        port.setForeground(color1);
        IPtext = new JTextField("127.0.0.1");
        PORTtext = new JTextField("9009");
        but = new JButton("Connect");
        but.addActionListener(this);
        pane.add(ip);
        pane.add(IPtext);
        pane.add(port);
        pane.add(PORTtext);
        pane.add(new JLabel());
        pane.add(but);
        frame = new JFrame("Connect parameters");
        (frame.getContentPane()).add(pane, BorderLayout.CENTER);
        frame.pack();
    }    
//================================================================================    
//              CONNECT DIALOG
//================================================================================     
    private void ConnectDialog(){ 
        frame.setVisible(true);
    }   
//================================================================================    
//              LOG INITIALIZE
//================================================================================     
    private void setLog(){
        JPanel pane = new JPanel(new GridLayout(2,0));
        input = new JTextField();
        input.setBorder(lowered);
        //Dimension dd = input.getPreferredSize();
        //input.setPreferredSize(new Dimension (200, dd.height));
        pane.add(input);
        butLog = new JButton(" Send ");
        butLog.setBorder(lowered);
        butLog.addActionListener(this);
        pane.add(input);
        pane.add(butLog);
        logPane = new JTextArea();
        //doc = logPane.getStyledDocument();
	//defaultAttributeSet = new SimpleAttributeSet(); 
        JScrollPane scroll = new JScrollPane(logPane);
        scroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2,2,2,2), 
                                                BorderFactory.createEtchedBorder(EtchedBorder.LOWERED)));
        frameLog = new JFrame("Log");
        (frameLog.getContentPane()).add(scroll, BorderLayout.CENTER);
        (frameLog.getContentPane()).add(pane, BorderLayout.SOUTH); 
        frameLog.pack();
        frameLog.setSize(300,200);
    }        
//================================================================================    
//              INITIALIZE FONTS, COLORS AND BORDERS 
//================================================================================    
    private void InitFonts(){
        color1 = new Color(102,102,153);
        color2 = new Color(204,204,255);
        lowEtached = BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
        empty = BorderFactory.createEmptyBorder(3,3,3,3);
        loweredBevel = BorderFactory.createLoweredBevelBorder();
        lowered = BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
        compound = BorderFactory.createCompoundBorder(empty,loweredBevel);
    }    
//================================================================================    
//              ACTION LISTENER 
//================================================================================     
    
    public void actionPerformed(ActionEvent e) {
        
        if(((e.getSource()).toString()).matches(".*JMenuItem.*")){
            JMenuItem source = (JMenuItem)(e.getSource());
            if ((source.getText())=="Connect"){
                ConnectDialog();
            }
             if ((source.getText())=="Disconnect"){
                try{
                    server.disconnect();
                    statusBar.setText("Disconnected");
                    DataPanel.removeAll();
                    TreePanel.removeAll();
                }
                catch (IOException exc){
                    statusBar.setText("Couldn't disconnect. "+exc.getMessage());
                    JOptionPane.showMessageDialog(new JFrame(), (exc.getMessage()).toString(), "Couldn't disconnect", JOptionPane.ERROR_MESSAGE);
                }
             }
            if ((source.getText())=="Console"){
                frameLog.setVisible(true);
            }
            if ((source.getText())=="About"){
                JOptionPane.showMessageDialog(new JFrame(), "Framsticks Server Client", "About", JOptionPane.INFORMATION_MESSAGE);
            }
        }
        else if(((e.getSource()).toString()).matches(".*JComboBox.*")){
                JComboBox source = (JComboBox)(e.getSource());
                if(hashTable.containsKey(source.getName())){
                    
                    String d[] = (String []) hashTable.get(source.getName());
                    if(d[1].equals("d")){
                        ArrayList L = new ArrayList();
                        L=GetInfo("set "+d[0]+" "+source.getName()+" "+source.getSelectedIndex());
                        logPane.append(">set "+d[0]+" "+source.getName()+" "+source.getSelectedIndex()+"\n");
                        updateLog(L, logPane);
                        L.clear();
                        L=GetInfo("get "+d[0]+" "+source.getName());
                        logPane.append(">get "+d[0]+" "+source.getName()+"\n");
                        updateLog(L, logPane);
                    }
                    else if(d[1].equals("s")){
                        ArrayList L = new ArrayList();
                        L=GetInfo("set "+d[0]+" "+source.getName()+" "+source.getSelectedItem());
                        logPane.append(">set "+d[0]+" "+source.getName()+" "+source.getSelectedItem()+"\n");
                        updateLog(L, logPane);
                        L.clear();
                        L=GetInfo("get "+d[0]+" "+source.getName());
                        logPane.append(">get "+d[0]+" "+source.getName()+"\n");
                        updateLog(L, logPane);
                    }
                }
        }
        else if(((e.getSource()).toString()).matches(".*JCheckBox.*")){
                
                JCheckBox source = (JCheckBox)(e.getSource());
                int dec = 0;
                float f = 0;
                if(source.isSelected()){dec = 1; f = 1;}
                
                if(hashTable.containsKey(source.getName())){
                    String d[] = (String []) hashTable.get(source.getName());
                    if(d[1].equals("d")){
                        ArrayList L = new ArrayList();
                        L=GetInfo("set "+d[0]+" "+source.getName()+" "+dec);
                        logPane.append(">set "+d[0]+" "+source.getName()+" "+dec+"\n");
                        updateLog(L, logPane);
                        L.clear();
                        L=GetInfo("get "+d[0]+" "+source.getName());
                        logPane.append(">get "+d[0]+" "+source.getName()+"\n");
                        updateLog(L, logPane);
                    }
                    else if(d[1].equals("f")){
                        ArrayList L = new ArrayList();
                        L=GetInfo("set "+d[0]+" "+source.getName()+" "+f);
                        logPane.append(">set "+d[0]+" "+source.getName()+" "+f+"\n");
                        updateLog(L, logPane);
                        L.clear();
                        L=GetInfo("get "+d[0]+" "+source.getName());
                        logPane.append(">set "+d[0]+" "+source.getName()+" "+dec+"\n");
                        updateLog(L, logPane);
                    }
                }
        }
        else if(((e.getSource()).toString()).matches(".*JButton.*")){
            if (e.getSource() == but){
            frame.setVisible(false);
            try{
                    server.connect(IPtext.getText(), Integer.parseInt(PORTtext.getText()));
                    statusBar.setText("Connected to Framsticks Server: "+IPtext.getText()+":"+PORTtext.getText());
                    setTreePanel();
                    thread.start();
            }
            catch (IOException exc){
                    statusBar.setText("Couldn't connect to server. "+exc.getMessage());
                    JOptionPane.showMessageDialog(new JFrame(), (exc.getMessage()).toString(), "Couldn't connect to server", JOptionPane.ERROR_MESSAGE); 
            }
            }
            else if(e.getSource() == butLog){
                ArrayList L = new ArrayList();
                L=GetInfo(input.getText());
                logPane.append(">"+input.getText());
                updateLog(L, logPane);
            }
            else {
            JButton source = (JButton)(e.getSource());
            if(hashTable.containsKey(source.getName())){
                String d[] = (String []) hashTable.get(source.getName());
                String s = (String)JOptionPane.showInputDialog(new JFrame(),
                        source.getName()+"\n"+source.getText()+"\n"+d[1]);

                if ((s != null) && (s.length() > 0)){
                    ArrayList L = new ArrayList();
                    L=GetInfo("call "+d[0]+" "+source.getName()+" "+s);
                    logPane.append(">call "+d[0]+" "+source.getName()+"\n");
                    updateLog(L, logPane);
                }                       
            }
                                  
        }
        }
      }
//================================================================================    
//              KEY LISTENER 
//================================================================================       
    
       public void keyPressed(KeyEvent e) {
           if(e.getKeyCode() == KeyEvent.VK_ENTER){
                if(((e.getSource()).toString()).matches(".*JTextField.*")){
                    JTextField text = (JTextField)(e.getSource());
                    if(hashTable.containsKey(text.getName())){
                        String d[] = (String []) hashTable.get(text.getName());
                        ArrayList L = new ArrayList();
                        L=GetInfo("set "+d[0]+" "+text.getName()+" "+text.getText());
                        logPane.append(">set "+d[0]+" "+text.getName()+" "+text.getText()+"\n");
                        updateLog(L, logPane);
                        L.clear();
                        L=GetInfo("get "+d[0]+" "+text.getName());
                        logPane.append(">get "+d[0]+" "+text.getName()+"\n");
                        updateLog(L, logPane);
                    }
                }
                if(((e.getSource()).toString()).matches(".*JTextArea.*")){
                    JTextArea text = (JTextArea)(e.getSource());
                    if(hashTable.containsKey(text.getName())){
                        String d[] = (String []) hashTable.get(text.getName());
                        ArrayList L = new ArrayList();
                        L=GetInfo("set "+d[0]+" "+text.getName()+" "+text.getText());
                        logPane.append(">set "+d[0]+" "+text.getName()+" "+text.getText()+"\n");
                        updateLog(L, logPane);
                        L.clear();
                        L=GetInfo("get "+d[0]+" "+text.getName());
                        logPane.append(">get "+d[0]+" "+text.getName()+"\n");
                        updateLog(L, logPane);
                    }
                }
            }
       }
       
       public void keyReleased(KeyEvent e) {
       }
       
       public void keyTyped(KeyEvent e) {
       }
    
//================================================================================    
//              CHANGE LISTENER 
//================================================================================        
       public void stateChanged (ChangeEvent e) {
           JSlider source = (JSlider)e.getSource();
           JComponent c = (JComponent)(source.getParent());
           JTextField text = (JTextField) c.getComponent(3);
           int val = (int)source.getValue();
           //if (!source.getValueIsAdjusting()) {
           if (source.getValueIsAdjusting()) {
                    text.setText(String.valueOf(val));
           }
           if(hashTable.containsKey(source.getName())){
                    String d[] = (String []) hashTable.get(source.getName());
                    if(d[1].equals("d")){
                        ArrayList L = new ArrayList();
                        L=GetInfo("set "+d[0]+" "+source.getName()+" "+Integer.parseInt(text.getText()));
                        
                        logPane.append("set "+d[0]+" "+source.getName()+" "+Integer.parseInt(text.getText()));
                        updateLog(L, logPane);
                        L.clear();
                        L=GetInfo("get "+d[0]+" "+source.getName());
                        logPane.append("get "+d[0]+" "+source.getName());
                        updateLog(L, logPane);
                    }
                    if(d[1].equals("f")){
                        ArrayList L = new ArrayList();
                        L=GetInfo("set "+d[0]+" "+source.getName()+" "+Float.parseFloat(text.getText()));
                        logPane.append("set "+d[0]+" "+source.getName()+" "+Float.parseFloat(text.getText()));
                        updateLog(L, logPane);
                        L.clear();
                        L=GetInfo("get "+d[0]+" "+source.getName());
                        logPane.append("get "+d[0]+" "+source.getName());
                        updateLog(L, logPane);
                    }
                }
       }
//================================================================================    
//              DYNAMIC TREE CLASS 
//================================================================================     
    
    class DynamicTree extends JPanel implements TreeSelectionListener{
        protected DefaultMutableTreeNode rootNode;
        protected DefaultTreeModel treeModel;
        protected JTree tree;

    public DynamicTree() {
        super(new GridLayout(1,0));       
        
        rootNode = new DefaultMutableTreeNode("Framsticks Server");
        treeModel = new DefaultTreeModel(rootNode);
        
        tree = new JTree(treeModel);
        tree.setEditable(true);
        tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        tree.setShowsRootHandles(true);
        tree.addTreeSelectionListener(this);
        
        JScrollPane scrollPane = new JScrollPane(tree);
        add(scrollPane);
    }
    
    
    public DefaultMutableTreeNode addObject(Object child) {
        DefaultMutableTreeNode parentNode = null;
        TreePath parentPath = tree.getSelectionPath();
        if (parentPath == null) {
            parentNode = rootNode;
        } else {
            parentNode = (DefaultMutableTreeNode)
                         (parentPath.getLastPathComponent());
        }
        return addObject(parentNode, child, true);
    } 

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child) {
        return addObject(parent, child, false);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        
        if (parent == null) { parent = rootNode;}
        boolean canAdd = true;
        
        for (int i=0; i<parent.getChildCount(); i++){
            if(((parent.getChildAt(i)).toString()).equals(child.toString())){
                canAdd = false;
                break;
            }
        }

        if(canAdd){
            treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        }
        if (shouldBeVisible) {
            tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }
    
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = null;
            
        try {
            TreePath parentPath = tree.getSelectionPath();
            node = (DefaultMutableTreeNode)
                   (parentPath.getLastPathComponent());

            if ((node.toString()).equals("Framsticks Server")){
                doData("/");
            }
            else if((node.toString()).equals("groups")){}
            else {
                String path = new String("/");
                String [] a = (parentPath.toString()).split(","); 
                for (int i=1; i<a.length; i++){
                    path = path+a[i].substring(1)+"/";
                }
                path=path.substring(0, path.length()-2);
                doData(path);
            }
        }
        catch (NullPointerException exc) {
        }        
    }  
}
//================================================================================    
//              myThread CLASS
//================================================================================
  class myThread extends Thread{
      private volatile Thread blinker;
      ArrayList evList = new ArrayList();
      String ev = new String();
      public myThread(){
          super();
      }
      
      public void start() {
        blinker = new Thread(this);
        blinker.start();
      }
      
      public void run(){
          Thread myThread = Thread.currentThread();
          while (blinker == myThread) {
              try{
                ev = server.SocketListen();
                if(!ev.equals("")){
                    eventPane.append(ev+"\n");
                }
              }
              catch (SocketException e){}
              catch (IOException e){}
              try{
                  myThread.sleep(100);
                  synchronized(this) {
                    while (threadSuspended)
                        wait();
                }
              }
              catch(InterruptedException exc){}
          }
      }
  }
  
  public synchronized void ThreadSuspended(){
      threadSuspended = !threadSuspended;
      if (!threadSuspended)
            notify();

  }
//================================================================================    
//              JSlider
//================================================================================       
    private Box boxSlider(String data[], Hashtable vHT, Hashtable hHT, int width){
        
        JSlider slider = new JSlider();
        slider = dataComp.InitSlider(data[1], data[3], vHT, hHT);
        slider.addChangeListener(this);
        
        JTextField tf = new JTextField();
        tf.setText(""+slider.getValue());
        tf.setName(data[1]);
        tf.setHorizontalAlignment(JTextField.CENTER);
        tf.setMaximumSize(new Dimension(50,20));
        tf.setPreferredSize(new Dimension(50,20));
        tf.setBackground(color2);
        tf.setBorder(lowEtached);
        tf.setEditable(false);

        JLabel label = new JLabel();
        label = dataComp.InitLabel(data[2]);
        label.setToolTipText(slider.getToolTipText());
        Dimension size = label.getPreferredSize();

        Box box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(new Dimension(5,0)));
        box.add(label);
        box.add(Box.createRigidArea(new Dimension((int)(width*1.1-size.width),0)));
        box.add(tf);
        box.add(Box.createRigidArea(new Dimension(10,0)));
        box.add(slider);
        box.add(Box.createRigidArea(new Dimension(10,0)));
      
    return box;    
    }
    

//================================================================================    
//              JCheckBox
//================================================================================    
    private Box boxCheckBox(String data[], Hashtable vHT, Hashtable hHT, int width){
        
        JCheckBox checkBox = new JCheckBox();
        checkBox = dataComp.InitCheckBox(data[1], data[2], vHT, hHT); 
        checkBox.addActionListener(this);
                
        Box box = Box.createHorizontalBox();       
        box.add(Box.createRigidArea(new Dimension((int)(width*1.1),0)));
        box.add(checkBox);      
    return box;            
    }
    
//================================================================================    
//              JTextArea
//================================================================================    
    private Box boxTextArea(String data[], Hashtable vHT, Hashtable hHT, int width){
        JTextArea text = new JTextArea();
        text = dataComp.InitTextArea(data[1], vHT, hHT);
        text.addKeyListener(this);
        JScrollPane pane = new JScrollPane(text);
        pane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        pane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        
        Dimension dd = pane.getPreferredSize();
        if (dd.height>400){
            pane.setPreferredSize(new Dimension(dd.width, 400));
        }
        
        
        JLabel label = new JLabel();
        label = dataComp.InitLabel(data[2]);
        label.setToolTipText(text.getToolTipText());
        Dimension size = label.getPreferredSize();
    
        Box box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(new Dimension(5,0)));
        box.add(label);
        box.add(Box.createRigidArea(new Dimension((int)(width*1.1-size.width),0)));
        box.add(pane);
        box.add(Box.createRigidArea(new Dimension(10,0)));
        
        return box;
    }    
    
//================================================================================    
//              JTextField
//================================================================================    
    private Box boxTextField(String data[], Hashtable vHT, Hashtable hHT, int width){
                  
        JTextField text = new JTextField();
        text = dataComp.InitTextField(data[1], vHT, hHT);
        text.addKeyListener(this);
        //Dimension dd = text.getPreferredSize();
        //text.setPreferredSize(new Dimension(Integer.MAX_VALUE, dd.height));
        
        JScrollPane pane = new JScrollPane(text);
        pane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        pane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        
        JLabel label = new JLabel();
        label = dataComp.InitLabel(data[2]);
        label.setToolTipText(text.getToolTipText());
        Dimension size = label.getPreferredSize();
        
        Box box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(new Dimension(5,0)));
        box.add(label);
        box.add(Box.createRigidArea(new Dimension((int)(width*1.1-size.width),0)));
        box.add(pane);
        box.add(Box.createRigidArea(new Dimension(10,0)));
        
    return box;               
    }    
    
//================================================================================    
//              JComboBox
//================================================================================     
    private Box boxComboBox(String data[], Hashtable vHT, Hashtable hHT, int width){
        
        Vector vector = new Vector();
        String [] a = data[3].split("~");
        for(int i=0; i<a.length-1; i++){
            vector.add(a[i+1]);                            
        }
        
        JComboBox comboBox = new JComboBox();
        comboBox = dataComp.InitComboBox(data[1], vector, data[5], vHT, hHT);
        comboBox.addActionListener(this);
        
               
        JLabel label = new JLabel();
        label = dataComp.InitLabel(data[2]);
        label.setToolTipText(comboBox.getToolTipText());
        Dimension size = label.getPreferredSize();
        
        Box box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(new Dimension(5,0)));
        box.add(label);
        box.add(Box.createRigidArea(new Dimension((int)(width*1.1-size.width),0)));
        box.add(comboBox);
        box.add(Box.createRigidArea(new Dimension(10,0)));
   
    return box;
    }
//================================================================================    
//              JButton
//================================================================================     
    private Box boxButton(String data[], Hashtable vHT, Hashtable hHT, int width){       
        
        JButton button = new JButton();
        button = dataComp.InitButton(data[1], data[2], vHT, hHT);
        button.addActionListener(this);      
        
        Box box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(new Dimension((int)(width*1.1+5),0)));
        box.add(button);
   
    return box;
    }    
//================================================================================    
//              LAYING OUT DATA COMPONENTS
//================================================================================    
 
 private void PresentData(Hashtable dHashtable, Hashtable vHashtable, Hashtable hHashtable, String path, String className){

     DataPanel.removeAll();
     DataPanel.setLayout(new BoxLayout(DataPanel, BoxLayout.Y_AXIS));
     //DataPanel.add(Box.createRigidArea(new Dimension(0,5)));
     
     hashTable.clear();
     dataLabel.setText("Class:  "+className);
     
     int width = 0;
     Enumeration enu = dHashtable.keys();
     while (enu.hasMoreElements()){
         String wrd = (String) enu.nextElement();
         try{
             String dd[] = (String []) dHashtable.get(wrd);
             if (!dd[0].equals("1")){
                 if (!dd[4].equals("32")){
                     JLabel l = new JLabel(dd[2]);
                     Dimension dim = l.getPreferredSize();
                     if (dim.width > width) {width = dim.width;}
                 }
             }
         }
         catch(NullPointerException e){}
     }
  
     Enumeration en = dHashtable.keys();
     while (en.hasMoreElements()){
        String word = (String) en.nextElement();
        try{
            String dat[] = (String []) dHashtable.get(word);
            if (!dat[4].equals("32")){
            if (!dat[4].equals("33")){
            if (!dat[4].equals("34")){    
                if (dat[0].equals("1")){
                    String [] setData = {path, dat[5]};
                    hashTable.put(dat[1], setData); 
                    Box box = Box.createHorizontalBox();
                    box = boxCheckBox(dat, vHashtable, hHashtable, width);
                    Dimension Dim = box.getPreferredSize();
                    //box.setPreferredSize(new Dimension(width, Dim.height));
                    box.setMinimumSize(new Dimension(Integer.MAX_VALUE, (int)(Dim.height*1.2)));
                    box.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)(Dim.height*1.2)));
                    box.setBorder(lowEtached);
                    box.setAlignmentX(Component.LEFT_ALIGNMENT);
                    DataPanel.add(box);
                }
                else if (dat[0].equals("2")){
                    String [] setData = {path, dat[5]};
                    hashTable.put(dat[1], setData);
                    Box box = Box.createHorizontalBox();
                    box = boxTextField(dat, vHashtable, hHashtable, width);
                    Dimension Dim = box.getPreferredSize();
                    //box.setPreferredSize(new Dimension(width, Dim.height));
                    box.setMinimumSize(new Dimension(Integer.MAX_VALUE, (int)(Dim.height*1.2)));
                    box.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)(Dim.height*1.2)));
                    box.setBorder(lowEtached);
                    box.setAlignmentX(Component.LEFT_ALIGNMENT);
                    DataPanel.add(box);
                }
                else if (dat[0].equals("3")){
                    String [] setData = {path, dat[5]};
                    hashTable.put(dat[1], setData);
                    Box box = Box.createHorizontalBox();
                    box = boxSlider(dat, vHashtable, hHashtable, width);
                    Dimension Dim = box.getPreferredSize();
                    //box.setPreferredSize(new Dimension(width, Dim.height));
                    box.setMinimumSize(new Dimension(Integer.MAX_VALUE, (int)(Dim.height*1.2)));
                    box.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)(Dim.height*1.2)));
                    box.setBorder(lowEtached);
                    box.setAlignmentX(Component.LEFT_ALIGNMENT);
                    DataPanel.add(box);
                }
                else if (dat[0].equals("4")){
                    String [] setData = {path, dat[5]};
                    hashTable.put(dat[1], setData);                
                    Box box = Box.createHorizontalBox();
                    box = boxTextArea(dat, vHashtable, hHashtable, width);
                    Dimension Dim = box.getPreferredSize();
                    //box.setPreferredSize(new Dimension(width, Dim.height));
                    box.setMinimumSize(new Dimension(Integer.MAX_VALUE, (int)(Dim.height*1.2)));
                    box.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)(Dim.height*1.2)));
                    box.setBorder(lowEtached);
                    box.setAlignmentX(Component.LEFT_ALIGNMENT);
                    DataPanel.add(box);
                }
                else if (dat[0].equals("5")){
                    String [] setData = {path, dat[5]};
                    hashTable.put(dat[1], setData);               
                    Box box = Box.createHorizontalBox();
                    box = boxComboBox(dat, vHashtable, hHashtable, width);
                    Dimension Dim = box.getPreferredSize();
                    //box.setPreferredSize(new Dimension(width, Dim.height));
                    box.setMinimumSize(new Dimension(Integer.MAX_VALUE, (int)(Dim.height*1.2)));
                    box.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)(Dim.height*1.2)));
                    box.setBorder(lowEtached);
                    box.setAlignmentX(Component.LEFT_ALIGNMENT);
                    DataPanel.add(box);
                }
                else if (dat[0].equals("6")){
                    String [] setData = {path, dat[3]};
                    hashTable.put(dat[1], setData);               
                    Box box = Box.createHorizontalBox();
                    box = boxButton(dat, vHashtable, hHashtable, width);
                    Dimension Dim = box.getPreferredSize();
                    //box.setPreferredSize(new Dimension(width, Dim.height));
                    box.setMinimumSize(new Dimension(Integer.MAX_VALUE, (int)(Dim.height*1.3)));
                    box.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)(Dim.height*1.3)));
                    box.setBorder(lowEtached);
                    box.setAlignmentX(Component.LEFT_ALIGNMENT);
                    DataPanel.add(box);
                }
            }
            }
            }
        }
        catch(NullPointerException e){}
     }
     DataPanel.add(Box.createRigidArea(new Dimension(0,15)));
     DataPanel.revalidate();
     DataPanel.repaint();
 }
//================================================================================    
//              UPDATE LOG
//================================================================================      
    private void updateLog(ArrayList list, JTextArea text){
        for (int i=0; i<list.size(); i++){
            text.append(list.get(i)+"\n");
        }
        text.append("\n");
    }
//================================================================================    
//              OBTAINING DATA FROM SERVER
//================================================================================      
    private ArrayList GetInfo(String path){ 
        ArrayList arrayList = new ArrayList();  
        ThreadSuspended();
        
        try{
            Thread.sleep(100);
            arrayList=server.getData(path);
        }
        catch (IOException exc){
            JOptionPane.showMessageDialog(new JFrame(), (exc.getMessage()).toString(), "IO Error", JOptionPane.ERROR_MESSAGE);
        }
        catch (InterruptedException exc){
            JOptionPane.showMessageDialog(new JFrame(), (exc.getMessage()).toString(), "Interrupted data flow", JOptionPane.ERROR_MESSAGE);
        }
        ThreadSuspended();
    return arrayList;
    }     

//================================================================================    
//              ADD NODES TO TREE
//================================================================================  
    private void addNode(Hashtable hTable){
        
        Enumeration en = hTable.keys();
        while (en.hasMoreElements()){
            String word = (String) en.nextElement();
            try{
                String dat[] = (String []) hTable.get(word);
                if (dat[0].equals("o")){
                    treePanel.addObject(word);
                }
                if (dat[0].equals("l")){
                    DefaultMutableTreeNode p = null;
                    p = treePanel.addObject(word);
                    if (!dat[1].equals("")){
                        for(int i=0; i<Integer.parseInt(dat[1]); i++){
                            treePanel.addObject(p,""+i);
                        }
                    }
                }
            }
            catch(NullPointerException e){} 
     }
    }
//================================================================================    
//              
//================================================================================      
    public void doData(String path){
        ArrayList L1 = new ArrayList();
        ArrayList L2 = new ArrayList();
        
        L1=GetInfo("info "+path);
        L2=GetInfo("get "+path);
        logPane.append(">info "+path+"\n");
        updateLog(L1, logPane);
        logPane.append(">get "+path+"\n");
        updateLog(L2, logPane);
        
        parser.ParseData(L1, L2);
        Hashtable nodeHT = new Hashtable();
        nodeHT = parser.getNodes();
        addNode(nodeHT);
        
        Hashtable dataHT = new Hashtable();
        dataHT = parser.getParsedTypes();
        
        Hashtable helpHT = new Hashtable();
        helpHT = parser.getHelp();
        
        Hashtable valueHT = new Hashtable();
        valueHT = parser.getValue();
        
        String className = new String();
        className = parser.getClassName();

        PresentData(dataHT, valueHT, helpHT, path, className);
    }
     
//================================================================================    
//              CREATE AND SHOW GUI FUNCTION
//================================================================================      
    
       private static void createAndShowGUI(){
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame f = new JFrame("FClient");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        JComponent newContentPane = new FClient();
        newContentPane.setOpaque(true);
        f.setContentPane(newContentPane);
        
        f.pack();
        f.setVisible(true);
       }

       
//================================================================================    
//              MAIN FUNCTION
//================================================================================  
       
       public static void main(String[] args){
           javax.swing.SwingUtilities.invokeLater(new Runnable(){
            public void run(){
                createAndShowGUI();
            }
           });
       }       
       
       
       
}

    
        
    


 