/* 
 * (C) Poznan University of Technology
 * File name: StatusBar.java.
 * Created on 2004-02-10 19:11:00.
 */
package frams_client_3d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;

import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

/**
 * Status bar pane class.
 * @author <a href="mailto:momat@man.poznan.pl">MoMaT</a>
 */
public class StatusBar extends JScrollPane {

	private SimpleAttributeSet[] attributes = null;
	private javax.swing.JTextPane jTextPane = null;
	private javax.swing.text.StyledDocument doc = null;

	static public int DEFAULT = 0;
	static public int WARNING = 1;
	static public int ERROR = 2;
	static public int INFO = 3;

	/**
	 * This is the default constructor
	 */
	public StatusBar() {
		super();
		initialize();
	}
	/**
	 * This method initializes this
	 * @return void
	 */
	private void initialize() {
		this.setViewportView(getJTextPane());
		this.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		this.setWheelScrollingEnabled(true);
		this.getVerticalScrollBar().setUnitIncrement(16);
		this.setAutoscrolls(true);
		Dimension size = jTextPane.getPreferredSize();
		this.setMinimumSize(size);
		initAttributes();
	}
	/**
	 * This method initializes jTextPane 
	 * @return javax.swing.JTextPane
	 */
	private javax.swing.JTextPane getJTextPane() {
		if (jTextPane == null) {
			jTextPane = new javax.swing.JTextPane();
			jTextPane.setCaretPosition(0);
			jTextPane.setMargin(new Insets(0,5,0,5));
			jTextPane.setPreferredSize(new Dimension(480, 36));
			jTextPane.setEditable(false);
			doc = jTextPane.getStyledDocument();
		}
		return jTextPane;
	}	
	/**
	 * Initialize styles for messages.
	 */
	private void initAttributes() {
			
		if (attributes == null) {
			attributes = new SimpleAttributeSet[4];

			//default			
			attributes[0] = new SimpleAttributeSet();
			StyleConstants.setFontFamily(attributes[0], "SansSerif");
			StyleConstants.setFontSize(attributes[0], 12);

			//warning
			attributes[1] = new SimpleAttributeSet(attributes[0]);			
			StyleConstants.setForeground(attributes[1], Color.red);

			//error			
			attributes[2] = new SimpleAttributeSet(attributes[1]);
			StyleConstants.setBold(attributes[2], true);

			//info
			attributes[3] = new SimpleAttributeSet(attributes[0]);
			StyleConstants.setForeground(attributes[3], Color.blue);
			StyleConstants.setItalic(attributes[3], true);
		}		
	}
	/**
	 * Adds the message to a text pane.
	 * @param text message to add
	 * @param type type of message
	 */
	public void addMessage(String text, int type)
	{
		try {
			doc.insertString(doc.getLength(), text+"\n", attributes[type]);
			Rectangle rect = new Rectangle(0, jTextPane.getHeight()-17,
				jTextPane.getWidth(), jTextPane.getHeight());
			jTextPane.scrollRectToVisible(rect);
		} catch (BadLocationException e) {
			e.printStackTrace();
			System.exit(-1);
		}
	}
}
