/* 
 * (C) Poznan University of Technology
 * File name: Camera.java.
 * Created on 2004-02-01 13:18:28.
 */
package frams_client_3d;

/**
 * Camera class.
 * @author <a href="mailto:momat@man.poznan.pl">MoMaT</a>
 */
public class Camera {
	
	private Point3D eye =  null;
	private Point3D view =  null;
	private Vector3D up = null;
	
	public void setPosition(float eye[], float view[], float up[])
	{
		this.eye = new Point3D(eye);
		this.view = new Point3D(view);
		this.up = new Vector3D(up); 
	}

	public void zoom(float speed)
	{
		Vector3D vector = eye.vector(view);
		vector.normalize();
		vector.mult(speed);		
		eye.add(vector);
	}

	public void move(float speed)
	{
		Vector3D vector = eye.vector(view);		
		vector.normalize();
		vector.mult(speed);		
		eye.add(vector);	
		view.add(vector);
	}

	public void level(float speed)
	{						
		Vector3D vector = new Vector3D(up);
		vector.mult(speed);
		eye.add(vector);
		view.add(vector);		
	}
	
	public void strafe(float speed)
	{
		Vector3D vector = eye.vector(view);
		vector.vectorProduct(up);
		vector.normalize();				
		vector.mult(speed);								
		eye.add(vector);
		view.add(vector);
	}	
	
	public void rotateHorizontal(float angle)
	{				 					
		Vector3D vector = view.vector(eye);
		vector.rotate(angle, up);
		eye = new Point3D(view);
		eye.add(vector);
	}
	
	public void rotateVertical(float angle)
	{
		Point3D upPoint = new Point3D(eye);
		upPoint.add(up);
		
		Vector3D vector = view.vector(eye);
		Vector3D axis = new Vector3D(vector);
		axis.vectorProduct(up);
		axis.normalize();
		
		vector.rotate(angle, axis);
		eye = new Point3D(view);
		eye.add(vector);
		
		vector = view.vector(upPoint);
		vector.rotate(angle, axis);
		upPoint = new Point3D(view);
		upPoint.add(vector);		
		up = eye.vector(upPoint);
	}
	/**
	 * Eye position getter.
	 * @return eye point
	 */
	public float[] getEye() {
		return eye.getPoint();
	}
	/**
	 * View position getter.
	 * @return view point
	 */
	public float[] getView() {
		return view.getPoint();
	}
	/**
	 * Up vector getter.
	 * @return up vector
	 */
	public float[] getUp() {
		return up.getVector();
	}
	/**
	 * View vector getter.
	 * @return view vector
	 */
	public Vector3D getViewVector()	{
		return eye.vector(view);
	}
}
