/* 
 * (C) Poznan University of Technology
 * File name: Point3D.java.
 * Created on 2004-02-12 00:51:35.
 */
package frams_client_3d;

/**
 * Three dimensional point class.
 * @author <a href="mailto:momat@man.poznan.pl">MoMaT</a>
 */
public class Point3D {

	private float[] p = {0, 0, 0};

	 /**
	 * Defualt parametrized constructor.
	 * @param px point x coordinate
	 * @param py point y coordinate
	 * @param pz point z coordinate
	 */
	public Point3D(float px, float py, float pz) {
		p[0] = px;
		p[1] = py;
		p[2] = pz;	
	}	
	/**
	 * Defualt parametrized constructor.
	 * @param point array of point coordinates
	 */
	public Point3D(float[] point) {
		p[0] = point[0];
		p[1] = point[1];
		p[2] = point[2];
	}
	/**
	 * Copy constructor.
	 * @param point a point object
	 */
	public Point3D(Point3D point) {
		float[] q = point.getPoint(); 
		p[0] = q[0];
		p[1] = q[1];
		p[2] = q[2];	
	}		
	/**
	 * Calcultes a vector from this to given point.
	 * @param point the vector end point
	 * @return a vector 
	 */
	public Vector3D vector(Point3D point) {
		float[] v = new float[3];
		float[] q = point.getPoint();
		
		v[0] = q[0]-p[0]; 
		v[1] = q[1]-p[1];
		v[2] = q[2]-p[2];
		return new Vector3D(v);
	}
	/**
	 * Point getter.
	 * @return array of point coordinates
	 */
	public float[] getPoint() {
		return p;
	}	
	/**
	 * Add a vector.
	 * @param vector
	 */
	public void add(Vector3D vector) {
		float v[] = vector.getVector();
		p[0] += v[0];
		p[1] += v[1];
		p[2] += v[2];
	}	
	/**
	 * Add a point.
	 * @param point
	 */
	public void add(Point3D point) {
		float[] q = point.getPoint();
		p[0] += q[0];
		p[1] += q[1];
		p[2] += q[2];
	}
}
