/* 
 * (C) Poznan University of Technology
 * File name: Creatures.java.
 * Created on 2004-01-25 13:38:55.
 */
package frams_client_3d;

/**
 * Framstick creature body class.
 * @author <a href="mailto:momat@man.poznan.pl">MoMaT</a>
 */
public class Creature {

	private String name;
	private String genotype;
	private int partsCount = 0;
	private int jointsCount = 0;

	private int[][] joints = null;
	private float[][] parts = null;
	
	private int group;
	private int index;
	
	/**
	 * Class constructor. Initializes data structure.
	 * @param name
	 * @param partsCount number of parts
	 * @param jointsCount number of joints
	 * @param group creature group
	 * @param index position in a group
	 */
	public Creature(String name, String genotype, int partsCount, int jointsCount,
		int group, int index) {
		
		this.name = name;
		this.genotype = genotype;;		
		this.parts = new float[partsCount][3];
		this.joints = new int[jointsCount][2];
		this.group = group;
		this.index = index;
	}
	/**
	 * Add joint to the creature body.
	 * @param p1
	 * @param p2
	 */
	public void addJoint(int p1, int p2) {
		joints[jointsCount][0] = p1;
		joints[jointsCount][1] = p2;
		++jointsCount;
	}
	/**
	 * Add part to the creature body.
	 * @param x
	 * @param y
	 * @param z
	 */
	public void addPart(float x, float y, float z) {
		parts[partsCount][0] = x;
		parts[partsCount][1] = y;
		parts[partsCount][2] = z;
		++partsCount;
	}
	
	public String toString() {
		return name;		
	}	
	
	public String getGenotype() {
		return genotype;		
	}
			
	public int[][] getJoints() {
		return joints;
	}
	
	public float[][] getParts() {
		return parts;
	}
	
	public int getGroup() {
		return group;
	}
	
	public int getIndex() {
		return index;
	}		
	/**
	 * Gets translation vector to the middle point of a joint.
	 * @param index index of joint in a joints array
	 * @return translation vector
	 */
	public float[] jointTranslation(int index) {
		Point3D p1 = new Point3D(parts[joints[index][0]]);
		Point3D p2 = new Point3D(parts[joints[index][1]]);		
		Vector3D vector = p1.vector(p2);
		
		vector.mult(0.5f);
		p1.add(vector);		
		return p1.getPoint();
	}	
	/**
	 * Calculates the length of vector between two joint points. 
	 * @param index index of joint in a joints array
	 * @return length of vector
	 */
	public float jointLength(int index) {
		Point3D p1 = new Point3D(parts[joints[index][0]]);
		Point3D p2 = new Point3D(parts[joints[index][1]]);		
		Vector3D vector = p1.vector(p2);
		
		return vector.length();
	}	
	/**
	 * Calculates the angle and the rotation axis between a joint and the base vector. 
	 * @param index index of joint in a joints array
	 * @return the array of angle and axis x, y, z coordinates
	 */
	public float[] jointRotation(int index) {
		Point3D p1 = new Point3D(parts[joints[index][0]]);
		Point3D p2 = new Point3D(parts[joints[index][1]]);		
		Vector3D vector = p1.vector(p2);		
		Vector3D base = new Vector3D(1, 0, 0);

		float cos = base.scalarProduct(vector)/vector.length();
		float angle = (float)(-Math.acos(cos)*180/Math.PI);

		vector.vectorProduct(base);				
		float[] v = vector.getVector();
		float[] result = new float[4];		
		result[0] = angle;
		result[1] = v[0];
		result[2] = v[1];
		result[3] = v[2];
		return result;
	}
}
