import java.awt.*;
import java.util.Hashtable;
import java.util.Vector;
import java.util.ArrayList;
import java.util.Enumeration;
import java.lang.String;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;


class Parser {
    Hashtable nodesHashtable, helpHashtable, dataHashtable, valueHashtable, objectHashtable;
    String className;
    
    Parser(){
        nodesHashtable = new Hashtable();
        helpHashtable  = new Hashtable();
        dataHashtable  = new Hashtable();
        valueHashtable = new Hashtable();
        objectHashtable = new Hashtable();
        className = new String();
    }
    
//================================================================================    
//              PARSING DATA MAIN FUNCTION
//================================================================================     
    public void ParseData (ArrayList listInfo, ArrayList listGet){
        SortObjects(listInfo, listGet); 
        dataHashtable.clear();
        dataHashtable = ParseType(objectHashtable);
    }

//================================================================================    
//              SORTING DATA 
//================================================================================      
    
  private void SortObjects(ArrayList listInfo, ArrayList listGet){
        
        boolean ok =false;
        boolean att = false;
        String ID = new String();
        String Name = new String();
        String Type = new String();
        String Flags = new String();
        
        nodesHashtable.clear();
        helpHashtable.clear();
        objectHashtable.clear();
        valueHashtable.clear();
        className = "";
              
        for(int i=0; i<listInfo.size(); i++){
            String s = (listInfo.get(i)).toString();    
            if (s.startsWith("class")){
                i++;
                className = ((listInfo.get(i)).toString()).substring(3);
            }
            if (s.startsWith("prop")){
                ok=true;
            }
            if(ok){
                if(s.startsWith("id")){
                    ID=s.substring(3);
                }
                else if(s.startsWith("name")){
                    Name=s.substring(5);
                }
                else if(s.startsWith("type")){
                    ArrayList val = new ArrayList();
                    for(int j=0; j<listGet.size()-1; j++){
                        String [] a = ((listGet.get(j)).toString()).split(":");
                        if(a[0].equals(ID)){
                            val.add(((listGet.get(j)).toString()).substring(ID.length()+1));
                            if(((listGet.get(j)).toString()).matches(".*~.*")){
                                j++;
                                while(!((listGet.get(j)).toString()).equals("~")){
                                    val.add((listGet.get(j)).toString());
                                    j++;
                                }
                            }
                            valueHashtable.put(ID, val);
                            break;
                        }
                    }

                    if(s.startsWith("type:o")){
                        String [] nodesData = {new String("o"), new String("")};
                        nodesHashtable.put(ID, nodesData);
                    }
                    else if (s.startsWith("type:l")){
                        String number = new String();
                        for (int j=0; j<listGet.size()-1; j++){
                            if(((listGet.get(j)).toString()).matches(ID+":.*")){
                                number = ((listGet.get(j)).toString()).substring(ID.length()+1);
                                break;
                            }
                        }
                        String [] nodesData = {new String("l"), number};
                        nodesHashtable.put(ID, nodesData);
                    }
                    else{
                        Type=s.substring(5);
                        att = true;
                    }
                }
                else if(s.startsWith("flags")){
                    Flags=s.substring(6);
                }
                else if(s.startsWith("help")){
                    ArrayList help = new ArrayList();
                    help.add(s.substring(5));
                    int j=i;
                    j++;
                    while (!((listInfo.get(j)).toString()).startsWith("prop")){
                        help.add((listInfo.get(j)).toString());
                        j++;
                        if (j==(listInfo.size()-1)){break;}
                    }
                    helpHashtable.put(ID, help);
                }
                else if(s.equals("")){
                    ok=false;
                    if (att){
                        String [] mainData = {ID, Name, Type, Flags};
                        objectHashtable.put(ID, mainData);
                    }

                    att=false;
                    ID="";
                    Name="";
                    Type="";
                    Flags="";
                }      
            }
        }
    }
   
//================================================================================    
//              PARSING TYPE DATA
//================================================================================      
    private Hashtable ParseType(Hashtable hashTable){

        Hashtable dataHashtable = new Hashtable();
        Enumeration en = hashTable.keys();
        while (en.hasMoreElements()){
        String word = (String) en.nextElement();
        try{
            String dat[] = (String []) hashTable.get(word);
            String Type = dat[2].toString();
            
            if(Type.startsWith("d")){
                            if(Type.matches("d 0 2 ~.*")){
                                String[] mainData = {new String("5"), dat[0], dat[1], dat[2], dat[3], new String("d")};
                                dataHashtable.put(dat[0], mainData);
                            }
                            else if(Type.matches("d 0 1 ~.*")){
                                String[] mainData = {new String("5"), dat[0], dat[1], dat[2], dat[3], new String("d")};
                                dataHashtable.put(dat[0], mainData);
                            }
                            else if(Type.matches("d 0 1")){
                                String[] mainData = {new String("1"), dat[0], dat[1], dat[2], dat[3], new String("d")};
                                dataHashtable.put(dat[0], mainData);
                            }
                            else if(Type.matches("d")){
                                String[] mainData = {new String("2"), dat[0], dat[1], dat[2], dat[3], new String("d")};
                                dataHashtable.put(dat[0], mainData);
                            }
                            else if(Type.matches("d [0-9] [0-9][0-9]*")){
                                String[] mainData = {new String("3"), dat[0], dat[1], dat[2], dat[3], new String("d")};
                                dataHashtable.put(dat[0], mainData);
                            }
                            else if(Type.matches("d [0-9] [0-9][0-9]* [a-z]")){
                                String[] mainData = {new String("2"), dat[0], dat[1], dat[2], dat[3], new String("d")};
                                dataHashtable.put(dat[0], mainData);
                            }
            }
            else if(Type.startsWith("f")){
                            if(Type.matches("f")){
                                String[] mainData = {new String("2"), dat[0], dat[1], dat[2], dat[3], new String("f")};
                                dataHashtable.put(dat[0], mainData);
                            }
                            else if(Type.matches("f 0 1")){
                                String[] mainData = {new String("1"), dat[0], dat[1], dat[2], dat[3], new String("f")};
                                dataHashtable.put(dat[0], mainData);
                            }
                            else if(Type.matches("f -*[0-9][0-9]* -*[0-9][0-9]*")){
                                String[] mainData = {new String("3"), dat[0], dat[1], dat[2], dat[3], new String("f")};
                                dataHashtable.put(dat[0], mainData);
                            }
            }
            else if(Type.startsWith("s")){
                            if(Type.matches(".* ~.*")){
                                String[] mainData = {new String("5"), dat[0], dat[1], dat[2], dat[3], new String("s")};
                                dataHashtable.put(dat[0], mainData);
                            }
                            else{
                                String[] mainData = {new String("4"), dat[0], dat[1], dat[2], dat[3], new String("s")};
                                dataHashtable.put(dat[0], mainData);
                            }
            }
            else if(Type.startsWith("p")){
                            String[] mainData = {new String("6"), dat[0], dat[1], dat[2], dat[3], new String("p")};
                            dataHashtable.put(dat[0], mainData);
            }
            else if(Type.startsWith("e")){}
            else if(Type.startsWith("x")){}
        }
        catch(NullPointerException e){
        }
        }
      return dataHashtable;
    } 
           
//================================================================================    
//              GET dataHashtable METHOD 
//================================================================================   
   public Hashtable getParsedTypes(){
       return dataHashtable;
   }

//================================================================================    
//              GET nodesHashtable METHOD 
//================================================================================   
   public Hashtable getNodes(){
       return nodesHashtable;
   }

//================================================================================    
//              GET helpHashtable METHOD 
//================================================================================   
   public Hashtable getHelp(){
       return helpHashtable;
   }
   
//================================================================================    
//              GET valueHashtable METHOD 
//================================================================================   
   public Hashtable getValue(){
       return valueHashtable;
   }   
   
//================================================================================    
//              GET className METHOD 
//================================================================================   
   public String getClassName(){
       return className;
   }   
}   
   
