/*
 * Decompiled with CFR 0.152.
 */
package frams_client_3d;

import frams_client_3d.Camera;
import frams_client_3d.Creature;
import frams_client_3d.Vector3D;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import javax.swing.JPanel;
import jgl.GL;
import jgl.GLU;
import jgl.GLUT;

public class ViewGL
extends JPanel {
    private static float ZOOM_SCALE = 0.05f;
    private static float MOVE_SCALE = 0.02f;
    private static float ROTATE_SCALE = 0.01f;
    private static int WHEEL_SCALE = 25;
    private static float[] eye = new float[]{10.0f, 10.0f, 30.0f};
    private static float[] view = new float[]{10.0f, 10.0f, 0.0f};
    private static float[] up = new float[]{0.0f, 1.0f, 0.0f};
    private static Vector3D initialViewVector = new Vector3D(view[0] - eye[0], view[1] - eye[1], view[2] - eye[2]);
    private Camera camera = new Camera();
    private boolean ready = false;
    private int displayList;
    private int heighfield;
    private int creaturesCount;
    private boolean isLeftButtonPressed = false;
    private boolean isRightButtonPressed = false;
    private boolean isMiddleButtonPressed = false;
    private int lastX;
    private int lastY;
    GL myGL = new GL();
    GLU myGLU = new GLU(this.myGL);
    GLUT myUT = new GLUT(this.myGL);

    public void init() {
        this.myUT.glutInitWindowSize(500, 400);
        this.myUT.glutInitWindowPosition(0, 0);
        this.myUT.glutCreateWindow((Component)this);
        this.initGL();
        this.myUT.glutDisplayFunc("display");
        initialViewVector.normalize();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ViewGL.this.mouse(e.getButton(), true, e.getX(), e.getY());
            }

            public void mouseReleased(MouseEvent e) {
                ViewGL.this.mouse(e.getButton(), false, e.getX(), e.getY());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                ViewGL.this.motion(e.getX(), e.getY());
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                ViewGL.this.isMiddleButtonPressed = true;
                ViewGL.this.motion(0, ViewGL.this.lastY + e.getWheelRotation() * WHEEL_SCALE);
                ViewGL.this.isMiddleButtonPressed = false;
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ViewGL.this.reshapeWindow(ViewGL.this.getSize().width, ViewGL.this.getSize().height);
            }
        });
        this.myUT.glutMainLoop();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.myGL.glXSwapBuffers(g, (ImageObserver)this);
    }

    public void mouse(int button, boolean isDown, int x, int y) {
        if (button == 1) {
            if (isDown) {
                this.isLeftButtonPressed = true;
                this.lastX = x;
                this.lastY = y;
            } else {
                this.isLeftButtonPressed = false;
            }
        } else if (button == 3) {
            if (isDown) {
                this.isRightButtonPressed = true;
                this.lastX = x;
                this.lastY = y;
            } else {
                this.isRightButtonPressed = false;
            }
        } else if (button == 2) {
            if (isDown) {
                this.isMiddleButtonPressed = true;
                this.lastY = y;
            } else {
                this.isMiddleButtonPressed = false;
            }
        }
    }

    public void motion(int x, int y) {
        if (this.isLeftButtonPressed) {
            float angleY = (float)(this.lastX - x) * ROTATE_SCALE;
            float angleZ = (float)(y - this.lastY) * ROTATE_SCALE;
            this.camera.rotateVertical(angleZ);
            this.camera.rotateHorizontal(angleY);
            Vector3D viewVector = this.camera.getViewVector();
            float cos = viewVector.scalarProduct(initialViewVector) / viewVector.length();
            if (cos > 0.0f) {
                this.myUT.glutPostRedisplay();
            } else {
                this.camera.rotateVertical(-angleZ);
                this.camera.rotateHorizontal(-angleY);
            }
        } else if (this.isRightButtonPressed) {
            float stepX = (float)(this.lastX - x) * MOVE_SCALE;
            float stepY = (float)(y - this.lastY) * MOVE_SCALE;
            this.camera.strafe(stepX);
            this.camera.level(stepY);
            this.myUT.glutPostRedisplay();
        } else if (this.isMiddleButtonPressed) {
            float stepY = (float)(y - this.lastY) * ZOOM_SCALE;
            this.camera.zoom(-stepY);
            this.myUT.glutPostRedisplay();
        }
        this.lastX = x;
        this.lastY = y;
    }

    public void reshapeWindow(int w, int h) {
        this.myGL.glViewport(0, 0, w, h);
        this.myGL.glMatrixMode(5889);
        this.myGL.glLoadIdentity();
        this.myGLU.gluPerspective(45.0, (double)w / (double)h, 0.1, 200.0);
        this.myGL.glMatrixMode(5888);
        this.myGL.glLoadIdentity();
        this.myUT.glutPostRedisplay();
    }

    private void initGL() {
        this.camera.setPosition(eye, view, up);
        this.myGLU.gluLookAt((double)eye[0], (double)eye[1], (double)eye[2], (double)view[0], (double)view[1], (double)view[2], (double)up[0], (double)up[1], (double)up[2]);
        this.myGL.glShadeModel(7424);
        this.myGL.glClearDepth(1.0);
        this.myGL.glDepthFunc(515);
        this.myGL.glEnable(2929);
        this.myGL.glEnable(2903);
    }

    public void display() {
        float[] eye = this.camera.getEye();
        float[] view = this.camera.getView();
        float[] up = this.camera.getUp();
        this.myGL.glClear(16640);
        this.myGL.glLoadIdentity();
        this.myGLU.gluLookAt((double)eye[0], (double)eye[1], (double)eye[2], (double)view[0], (double)view[1], (double)view[2], (double)up[0], (double)up[1], (double)up[2]);
        if (this.heighfield != 0) {
            this.myGL.glCallList(this.heighfield);
        }
        int i = 0;
        while (i < this.creaturesCount) {
            this.myGL.glCallList(this.displayList + i);
            ++i;
        }
        this.myGL.glFlush();
    }

    private void drawCube(float[] translate, float[] scale, float[] rotate, int color) {
        float[][] Diffuse = new float[][]{{1.0f, 0.0f, 0.0f, 0.5f}, {0.0f, 0.5f, 1.0f, 0.5f}};
        this.myGL.glColor3fv(Diffuse[color]);
        this.myGL.glTranslatef(translate[0], translate[1], translate[2]);
        this.myGL.glRotatef(rotate[0], rotate[1], rotate[2], rotate[3]);
        this.myGL.glScalef(scale[0], scale[1], scale[2]);
        this.myGL.glBegin(8);
        this.myGL.glNormal3f(0.0f, 0.0f, 1.0f);
        this.myGL.glVertex3f(-1.0f, -1.0f, 1.0f);
        this.myGL.glNormal3f(0.0f, 0.0f, 1.0f);
        this.myGL.glVertex3f(1.0f, -1.0f, 1.0f);
        this.myGL.glNormal3f(0.0f, 0.0f, 1.0f);
        this.myGL.glVertex3f(1.0f, 1.0f, 1.0f);
        this.myGL.glNormal3f(0.0f, 0.0f, 1.0f);
        this.myGL.glVertex3f(-1.0f, 1.0f, 1.0f);
        this.myGL.glNormal3f(0.0f, 0.0f, -1.0f);
        this.myGL.glVertex3f(-1.0f, -1.0f, -1.0f);
        this.myGL.glNormal3f(0.0f, 0.0f, 1.0f);
        this.myGL.glVertex3f(-1.0f, 1.0f, -1.0f);
        this.myGL.glNormal3f(0.0f, 0.0f, 1.0f);
        this.myGL.glVertex3f(1.0f, 1.0f, -1.0f);
        this.myGL.glNormal3f(0.0f, 0.0f, 1.0f);
        this.myGL.glVertex3f(1.0f, -1.0f, -1.0f);
        this.myGL.glNormal3f(0.0f, 1.0f, 0.0f);
        this.myGL.glVertex3f(-1.0f, 1.0f, -1.0f);
        this.myGL.glNormal3f(0.0f, 1.0f, 0.0f);
        this.myGL.glVertex3f(-1.0f, 1.0f, 1.0f);
        this.myGL.glNormal3f(0.0f, 1.0f, 0.0f);
        this.myGL.glVertex3f(1.0f, 1.0f, 1.0f);
        this.myGL.glNormal3f(0.0f, 1.0f, 0.0f);
        this.myGL.glVertex3f(1.0f, 1.0f, -1.0f);
        this.myGL.glNormal3f(0.0f, -1.0f, 0.0f);
        this.myGL.glVertex3f(-1.0f, -1.0f, -1.0f);
        this.myGL.glNormal3f(0.0f, -1.0f, 0.0f);
        this.myGL.glVertex3f(1.0f, -1.0f, -1.0f);
        this.myGL.glNormal3f(0.0f, -1.0f, 0.0f);
        this.myGL.glVertex3f(1.0f, -1.0f, 1.0f);
        this.myGL.glNormal3f(0.0f, -1.0f, 0.0f);
        this.myGL.glVertex3f(-1.0f, -1.0f, 1.0f);
        this.myGL.glNormal3f(1.0f, 0.0f, 0.0f);
        this.myGL.glNormal3f(1.0f, 0.0f, 0.0f);
        this.myGL.glVertex3f(1.0f, -1.0f, -1.0f);
        this.myGL.glNormal3f(1.0f, 0.0f, 0.0f);
        this.myGL.glVertex3f(1.0f, 1.0f, -1.0f);
        this.myGL.glNormal3f(1.0f, 0.0f, 0.0f);
        this.myGL.glVertex3f(1.0f, 1.0f, 1.0f);
        this.myGL.glNormal3f(1.0f, 0.0f, 0.0f);
        this.myGL.glVertex3f(1.0f, -1.0f, 1.0f);
        this.myGL.glNormal3f(-1.0f, 0.0f, 0.0f);
        this.myGL.glNormal3f(-1.0f, 0.0f, 0.0f);
        this.myGL.glVertex3f(-1.0f, -1.0f, -1.0f);
        this.myGL.glNormal3f(-1.0f, 0.0f, 0.0f);
        this.myGL.glVertex3f(-1.0f, -1.0f, 1.0f);
        this.myGL.glNormal3f(-1.0f, 0.0f, 0.0f);
        this.myGL.glVertex3f(-1.0f, 1.0f, 1.0f);
        this.myGL.glNormal3f(-1.0f, 0.0f, 0.0f);
        this.myGL.glVertex3f(-1.0f, 1.0f, -1.0f);
        this.myGL.glEnd();
    }

    public void setCreatures(ArrayList creatures) {
        this.creaturesCount = creatures.size();
        this.displayList = this.myGL.glGenLists(this.creaturesCount);
        int i = 0;
        while (i < creatures.size()) {
            this.setCreature((Creature)creatures.get(i), this.displayList + i);
            ++i;
        }
        this.myUT.glutPostRedisplay();
    }

    private void setCreature(Creature creature, int list) {
        float[] partScale = new float[]{0.1f, 0.1f, 0.1f};
        float[] jointScale = new float[]{0.05f, 0.05f, 0.05f};
        float[] rotate = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] r = new float[]{1.0f, 1.0f, 1.0f};
        float[][] parts = creature.getParts();
        int[][] joints = creature.getJoints();
        this.myGL.glNewList(list, 4864);
        int i = 0;
        while (i < parts.length) {
            this.myGL.glPushMatrix();
            this.drawCube(parts[i], partScale, rotate, 0);
            this.myGL.glPopMatrix();
            ++i;
        }
        i = 0;
        while (i < joints.length) {
            jointScale[0] = creature.jointLength(i) / 2.0f;
            this.myGL.glPushMatrix();
            this.drawCube(creature.jointTranslation(i), jointScale, creature.jointRotation(i), 1);
            this.myGL.glPopMatrix();
            ++i;
        }
        this.myGL.glEndList();
    }

    public void setHeighfield(ArrayList points, ArrayList faces) {
        float[] Diffuse = new float[]{1.0f, 1.0f, 0.6f, 1.0f};
        this.heighfield = this.myGL.glGenLists(1);
        this.myGL.glNewList(this.heighfield, 4864);
        this.myGL.glColor3fv(Diffuse);
        int i = 0;
        while (i < faces.size()) {
            String[] face = (String[])faces.get(i);
            if (3 == face.length) {
                this.myGL.glBegin(5);
            } else if (4 == face.length) {
                this.myGL.glBegin(8);
            } else {
                this.myGL.glBegin(10);
            }
            int j = 0;
            while (j < face.length) {
                int index = Integer.parseInt(face[j]);
                String[] point = (String[])points.get(index);
                this.myGL.glVertex3f(Float.parseFloat(point[0]), Float.parseFloat(point[1]), Float.parseFloat(point[2]) - 0.1f);
                ++j;
            }
            this.myGL.glEnd();
            ++i;
        }
        this.myGL.glEndList();
        this.myUT.glutPostRedisplay();
    }
}

