/*
 * Decompiled with CFR 0.152.
 */
package jgl.glu;

import jgl.GL;
import jgl.GLU;
import jgl.glu.nurbs_ct_curvs;
import jgl.glu.nurbs_ct_surfs;
import jgl.glu.nurbs_curves;
import jgl.glu.nurbs_knot;
import jgl.glu.nurbs_surfaces;

public class GLUnurbsObj {
    private GL JavaGL;
    private GLU JavaGLU;
    public static final int GLU_NURBS_CURVE = 0;
    public static final int GLU_NURBS_SURFACE = 1;
    public static final int GLU_NURBS_TRIM = 2;
    public static final int GLU_NURBS_NO_TRIM = 3;
    public static final int GLU_NURBS_TRIM_DONE = 4;
    public static final int GLU_NURBS_NONE = 5;
    public static final int GLU_TRIM_NURBS = 0;
    public static final int GLU_TRIM_PWL = 1;
    public float sampling_tolerance = 50.0f;
    public int display_mode = 100012;
    public boolean culling = false;
    public boolean auto_load_matrix = true;
    public int error = 0;
    public int type = 5;
    public float[] sampling_model = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public float[] sampling_proj = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public int[] sampling_viewport = new int[4];
    public nurbs_surfaces surface = new nurbs_surfaces();
    public nurbs_curves curve = new nurbs_curves();

    private void set_new_t_min_t_max(nurbs_knot nurbs_knot2, nurbs_knot nurbs_knot3, nurbs_knot nurbs_knot4, nurbs_knot nurbs_knot5, float f, float f2) {
        if (nurbs_knot2.unified_nknots != 0) {
            nurbs_knot2.set_new_min_max(f, f2);
        } else if (nurbs_knot2.nknots != 0) {
            nurbs_knot2.set_knot_min_max(f, f2);
        }
        if (nurbs_knot3.unified_nknots != 0) {
            nurbs_knot3.set_new_min_max(f, f2);
        }
        if (nurbs_knot4.unified_nknots != 0) {
            nurbs_knot4.set_new_min_max(f, f2);
        }
        if (nurbs_knot5.unified_nknots != 0) {
            nurbs_knot5.set_new_min_max(f, f2);
        }
    }

    private void select_knot_working_range(nurbs_knot nurbs_knot2, nurbs_knot nurbs_knot3, nurbs_knot nurbs_knot4, nurbs_knot nurbs_knot5) {
        int n = nurbs_knot2.nknots;
        if (nurbs_knot3.unified_nknots != 0) {
            n += nurbs_knot3.nknots;
        }
        if (nurbs_knot4.unified_nknots != 0) {
            n += nurbs_knot4.nknots;
        }
        if (nurbs_knot5.unified_nknots != 0) {
            n += nurbs_knot5.nknots;
        }
        float f = nurbs_knot2.knot[nurbs_knot2.t_min];
        float f2 = nurbs_knot2.knot[nurbs_knot2.t_max];
        if (n != nurbs_knot2.nknots) {
            nurbs_knot2.unified_knot = new float[n];
            nurbs_knot2.unified_nknots = nurbs_knot2.nknots;
            System.arraycopy(nurbs_knot2.knot, 0, nurbs_knot2.unified_knot, 0, nurbs_knot2.nknots);
            if (nurbs_knot3.unified_nknots != 0) {
                if (nurbs_knot3.knot[nurbs_knot3.t_min] > f) {
                    f = nurbs_knot3.knot[nurbs_knot3.t_min];
                }
                if (nurbs_knot3.knot[nurbs_knot3.t_max] < f2) {
                    f2 = nurbs_knot3.knot[nurbs_knot3.t_max];
                }
                nurbs_knot3.unified_knot = new float[n];
                nurbs_knot3.unified_nknots = nurbs_knot3.nknots;
                System.arraycopy(nurbs_knot3.knot, 0, nurbs_knot3.unified_knot, 0, nurbs_knot3.nknots);
            }
            if (nurbs_knot4.unified_nknots != 0) {
                if (nurbs_knot4.knot[nurbs_knot4.t_min] > f) {
                    f = nurbs_knot4.knot[nurbs_knot4.t_min];
                }
                if (nurbs_knot4.knot[nurbs_knot4.t_max] < f2) {
                    f2 = nurbs_knot4.knot[nurbs_knot4.t_max];
                }
                nurbs_knot4.unified_knot = new float[n];
                nurbs_knot4.unified_nknots = nurbs_knot4.nknots;
                System.arraycopy(nurbs_knot4.knot, 0, nurbs_knot4.unified_knot, 0, nurbs_knot4.nknots);
            }
            if (nurbs_knot5.unified_nknots != 0) {
                if (nurbs_knot5.knot[nurbs_knot5.t_min] > f) {
                    f = nurbs_knot5.knot[nurbs_knot5.t_min];
                }
                if (nurbs_knot5.knot[nurbs_knot5.t_max] < f2) {
                    f2 = nurbs_knot5.knot[nurbs_knot5.t_max];
                }
                nurbs_knot5.unified_knot = new float[n];
                nurbs_knot5.unified_nknots = nurbs_knot5.nknots;
                System.arraycopy(nurbs_knot5.knot, 0, nurbs_knot5.unified_knot, 0, nurbs_knot5.nknots);
            }
            if (f2 < f) {
                nurbs_knot2.unified_nknots = 0;
                nurbs_knot3.unified_nknots = 0;
                nurbs_knot4.unified_nknots = 0;
                nurbs_knot5.unified_nknots = 0;
            } else {
                if (nurbs_knot3.unified_nknots != 0) {
                    nurbs_knot2.collect(nurbs_knot3, f, f2);
                }
                if (nurbs_knot4.unified_nknots != 0) {
                    nurbs_knot2.collect(nurbs_knot4, f, f2);
                }
                if (nurbs_knot5.unified_nknots != 0) {
                    nurbs_knot2.collect(nurbs_knot5, f, f2);
                }
                if (nurbs_knot3.unified_nknots != 0) {
                    nurbs_knot3.collect(nurbs_knot2, f, f2);
                }
                if (nurbs_knot4.unified_nknots != 0) {
                    nurbs_knot4.collect(nurbs_knot2, f, f2);
                }
                if (nurbs_knot5.unified_nknots != 0) {
                    nurbs_knot5.collect(nurbs_knot2, f, f2);
                }
                this.set_new_t_min_t_max(nurbs_knot2, nurbs_knot3, nurbs_knot4, nurbs_knot5, f, f2);
            }
        } else {
            nurbs_knot2.unified_nknots = 0;
        }
    }

    private int convert_curves(nurbs_ct_curvs nurbs_ct_curvs2) {
        nurbs_knot nurbs_knot2 = new nurbs_knot();
        nurbs_knot nurbs_knot3 = new nurbs_knot();
        nurbs_knot nurbs_knot4 = new nurbs_knot();
        nurbs_knot nurbs_knot5 = new nurbs_knot();
        int n = this.curve.fill_knot(nurbs_knot2, nurbs_knot3, nurbs_knot4, nurbs_knot5);
        if (n != 0) {
            this.glu_error(n);
            return 100103;
        }
        this.select_knot_working_range(nurbs_knot2, nurbs_knot3, nurbs_knot4, nurbs_knot5);
        nurbs_ct_curvs2.convert(nurbs_knot2, nurbs_knot3, nurbs_knot4, nurbs_knot5, this.curve);
        return 0;
    }

    private int convert_surfaces(nurbs_ct_surfs nurbs_ct_surfs2) {
        nurbs_knot nurbs_knot2 = new nurbs_knot();
        nurbs_knot nurbs_knot3 = new nurbs_knot();
        nurbs_knot nurbs_knot4 = new nurbs_knot();
        nurbs_knot nurbs_knot5 = new nurbs_knot();
        nurbs_knot nurbs_knot6 = new nurbs_knot();
        nurbs_knot nurbs_knot7 = new nurbs_knot();
        nurbs_knot nurbs_knot8 = new nurbs_knot();
        nurbs_knot nurbs_knot9 = new nurbs_knot();
        int n = this.surface.fill_knot(nurbs_knot2, nurbs_knot3, nurbs_knot4, nurbs_knot5, nurbs_knot6, nurbs_knot7, nurbs_knot8, nurbs_knot9);
        if (n != 0) {
            this.glu_error(n);
            return 100103;
        }
        this.select_knot_working_range(nurbs_knot2, nurbs_knot4, nurbs_knot6, nurbs_knot8);
        this.select_knot_working_range(nurbs_knot3, nurbs_knot5, nurbs_knot7, nurbs_knot9);
        nurbs_ct_surfs2.convert(nurbs_knot2, nurbs_knot3, nurbs_knot4, nurbs_knot5, nurbs_knot6, nurbs_knot7, nurbs_knot8, nurbs_knot9, this.surface);
        return 0;
    }

    private int calc_factor(float[][] fArray, int n, int n2, int n3) {
        double d;
        double d2;
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        int[] nArray = new int[4];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        this.JavaGL.glGetDoublev(2982, dArray);
        this.JavaGL.glGetDoublev(2983, dArray2);
        this.JavaGL.glGetIntegerv(2978, nArray);
        if (n3 == 4) {
            d2 = fArray[n2][3];
            d = (double)fArray[n2][0] / d2;
            d3 = (double)fArray[n2][1] / d2;
            d4 = (double)fArray[n2][2] / d2;
        } else {
            d = fArray[n2][0];
            d3 = fArray[n2][1];
            d4 = fArray[n2][2];
        }
        this.JavaGLU.gluProject(d, d3, d4, dArray, dArray2, nArray, dArray3, dArray4, dArray7);
        int n4 = 1;
        while (n4 < n) {
            if (n3 == 4) {
                d2 = fArray[n2 + n4][3];
                d = (double)fArray[n2 + n4][0] / d2;
                d3 = (double)fArray[n2 + n4][1] / d2;
                d4 = (double)fArray[n2 + n4][2] / d2;
            } else {
                d = fArray[n2 + n4][0];
                d3 = fArray[n2 + n4][1];
                d4 = fArray[n2 + n4][2];
            }
            if (this.JavaGLU.gluProject(d, d3, d4, dArray, dArray2, nArray, dArray5, dArray6, dArray7)) {
                double d6 = dArray5[0] - dArray3[0];
                double d7 = dArray6[0] - dArray4[0];
                d5 += Math.sqrt(d6 * d6 + d7 * d7);
            }
            dArray3[0] = dArray5[0];
            dArray4[0] = dArray6[0];
            ++n4;
        }
        return (int)((d5 /= (double)this.sampling_tolerance) + 1.0);
    }

    private void sampling_2d(nurbs_ct_curvs nurbs_ct_curvs2, int[] nArray) {
        this.glu_set_sampling_matrices();
        float[][] fArray = nurbs_ct_curvs2.geom.ctrl;
        int n = 0;
        while (n < nurbs_ct_curvs2.bezier_cnt) {
            int n2 = this.calc_factor(nurbs_ct_curvs2.geom.ctrl, this.curve.geom.c.order, n * this.curve.geom.c.order, this.curve.geom.dim);
            nArray[n] = n2 == 0 ? 1 : n2;
            ++n;
        }
        this.glu_revert_sampling_matrices();
    }

    private void sampling_3d(nurbs_ct_surfs nurbs_ct_surfs2, int[][] nArray, int[][] nArray2) {
        int n;
        int n2;
        int n3;
        this.glu_set_sampling_matrices();
        float[][][] fArray = nurbs_ct_surfs2.geom.ctrl;
        int n4 = 0;
        while (n4 < nurbs_ct_surfs2.t_bezier_cnt) {
            nArray2[n4][1] = n3 = this.calc_factor(fArray[0], this.surface.geom.t.order, n4 * this.surface.geom.t.order, this.surface.geom.dim);
            n2 = 1;
            while (n2 < nurbs_ct_surfs2.s_bezier_cnt) {
                n = this.calc_factor(fArray[n2 * this.surface.geom.s.order], this.surface.geom.t.order, n4 * this.surface.geom.t.order, this.surface.geom.dim);
                if (n > n3) {
                    n3 = n;
                }
                ++n2;
            }
            nArray2[n4][2] = n = this.calc_factor(fArray[n2 * this.surface.geom.s.order - 1], this.surface.geom.t.order, n4 * this.surface.geom.t.order, this.surface.geom.dim);
            nArray2[n4][0] = n > n3 ? n : n3;
            ++n4;
        }
        fArray = new float[nurbs_ct_surfs2.geom.t_pt_cnt][nurbs_ct_surfs2.geom.s_pt_cnt][this.surface.geom.dim];
        n2 = 0;
        while (n2 < nurbs_ct_surfs2.geom.s_pt_cnt) {
            n4 = 0;
            while (n4 < nurbs_ct_surfs2.geom.t_pt_cnt) {
                fArray[n4][n2] = nurbs_ct_surfs2.geom.ctrl[n2][n4];
                ++n4;
            }
            ++n2;
        }
        n4 = 0;
        while (n4 < nurbs_ct_surfs2.t_bezier_cnt) {
            nArray[n4][1] = n3 = this.calc_factor(fArray[0], this.surface.geom.s.order, n4 * this.surface.geom.s.order, this.surface.geom.dim);
            n2 = 1;
            while (n2 < nurbs_ct_surfs2.s_bezier_cnt) {
                n = this.calc_factor(fArray[n2 * this.surface.geom.t.order], this.surface.geom.s.order, n4 * this.surface.geom.s.order, this.surface.geom.dim);
                if (n > n3) {
                    n3 = n;
                }
                ++n2;
            }
            nArray[n4][2] = n = this.calc_factor(fArray[n2 * this.surface.geom.t.order - 1], this.surface.geom.s.order, n4 * this.surface.geom.s.order, this.surface.geom.dim);
            nArray[n4][0] = n > n3 ? n : n3;
            ++n4;
        }
        this.glu_revert_sampling_matrices();
    }

    private boolean point_in_viewport(float[] fArray, int n) {
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        int[] nArray = new int[4];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        this.JavaGL.glGetDoublev(2982, dArray);
        this.JavaGL.glGetDoublev(2983, dArray2);
        this.JavaGL.glGetIntegerv(2978, nArray);
        if (n == 3) {
            double d = fArray[0];
            double d2 = fArray[1];
            double d3 = fArray[2];
            this.JavaGLU.gluProject(d, d2, d3, dArray, dArray2, nArray, dArray3, dArray4, dArray5);
        } else {
            double d = fArray[3];
            double d4 = (double)fArray[0] / d;
            double d5 = (double)fArray[1] / d;
            double d6 = (double)fArray[2] / d;
            this.JavaGLU.gluProject(d4, d5, d6, dArray, dArray2, nArray, dArray3, dArray4, dArray5);
        }
        return dArray3[0] >= (double)nArray[0] && dArray3[0] < (double)nArray[2] && dArray4[0] >= (double)nArray[1] && dArray4[0] < (double)nArray[3];
    }

    public boolean culling_test_2d(float[][] fArray, int n, int n2, int n3) {
        if (!this.culling) {
            return false;
        }
        this.glu_set_sampling_matrices();
        int n4 = 0;
        while (n4 < n) {
            if (this.point_in_viewport(fArray[n4], n3)) {
                return false;
            }
            ++n4;
        }
        this.glu_revert_sampling_matrices();
        return true;
    }

    public boolean culling_test_3d(float[][][] fArray, int n, int n2, int n3, int n4, int n5) {
        if (!this.culling) {
            return false;
        }
        this.glu_set_sampling_matrices();
        int n6 = 0;
        while (n6 < n) {
            int n7 = 0;
            while (n7 < n2) {
                if (this.point_in_viewport(fArray[n6][n7], n5)) {
                    return false;
                }
                ++n7;
            }
            ++n6;
        }
        this.glu_revert_sampling_matrices();
        return true;
    }

    private void do_curve() {
        nurbs_ct_curvs nurbs_ct_curvs2 = new nurbs_ct_curvs();
        int n = this.curve.test();
        if (n != 0) {
            this.glu_error(n);
            return;
        }
        if (this.convert_curves(nurbs_ct_curvs2) != 0) {
            return;
        }
        nurbs_ct_curvs2.augment(this.curve);
        int[] nArray = new int[nurbs_ct_curvs2.bezier_cnt];
        this.sampling_2d(nurbs_ct_curvs2, nArray);
        nurbs_ct_curvs2.draw(this, this.JavaGL, this.curve, nArray);
    }

    private void do_surface() {
        nurbs_ct_surfs nurbs_ct_surfs2 = new nurbs_ct_surfs();
        int n = this.surface.test();
        if (n != 0) {
            this.glu_error(n);
            return;
        }
        if (this.convert_surfaces(nurbs_ct_surfs2) != 0) {
            return;
        }
        nurbs_ct_surfs2.augment(this.surface);
        int[][] nArray = new int[nurbs_ct_surfs2.s_bezier_cnt][3];
        int[][] nArray2 = new int[nurbs_ct_surfs2.t_bezier_cnt][3];
        this.sampling_3d(nurbs_ct_surfs2, nArray, nArray2);
        nurbs_ct_surfs2.draw(this, this.JavaGL, this.display_mode, this.surface, nArray, nArray2);
    }

    public void glu_error(int n) {
        this.error = n;
        System.out.print("NURBS error " + n + " ");
        GLU.gluErrorString(n);
    }

    public void glu_load_sampling_matrices(float[] fArray, float[] fArray2, int[] nArray) {
        System.arraycopy(fArray, 0, this.sampling_model, 0, 16);
        System.arraycopy(fArray2, 0, this.sampling_proj, 0, 16);
        System.arraycopy(nArray, 0, this.sampling_viewport, 0, 4);
    }

    public void glu_set_sampling_matrices() {
        if (!this.auto_load_matrix) {
            this.JavaGL.glPushAttrib(6144);
            this.JavaGL.glViewport(this.sampling_viewport[0], this.sampling_viewport[1], this.sampling_viewport[2], this.sampling_viewport[3]);
            this.JavaGL.glMatrixMode(5889);
            this.JavaGL.glPushMatrix();
            this.JavaGL.glLoadMatrixf(this.sampling_proj);
            this.JavaGL.glMatrixMode(5888);
            this.JavaGL.glPushMatrix();
            this.JavaGL.glLoadMatrixf(this.sampling_model);
        }
    }

    public void glu_revert_sampling_matrices() {
        if (!this.auto_load_matrix) {
            this.JavaGL.glMatrixMode(5888);
            this.JavaGL.glPopMatrix();
            this.JavaGL.glMatrixMode(5889);
            this.JavaGL.glPopMatrix();
            this.JavaGL.glPopAttrib();
        }
    }

    public void glu_set_sampling_tolerance(float f) {
        if (f <= 0.0f) {
            this.glu_error(100901);
            return;
        }
        this.sampling_tolerance = f;
    }

    public void glu_set_display_mode(int n) {
        if (n != 100012 && n != 100240 && n != 100241) {
            this.glu_error(100900);
            return;
        }
        if (this.type == 0) {
            this.glu_error(100276);
            return;
        }
        this.display_mode = n;
    }

    public void glu_set_culling(boolean bl) {
        this.culling = bl;
    }

    public void glu_set_auto_load_matrix(boolean bl) {
        this.auto_load_matrix = bl;
    }

    public void glu_begin_curve() {
        switch (this.type) {
            case 5: {
                this.type = 0;
                this.curve.geom.type = 100900;
                this.curve.color.type = 100900;
                this.curve.normal.type = 100900;
                this.curve.texture.type = 100900;
                break;
            }
            case 0: {
                this.glu_error(100256);
            }
        }
    }

    public void glu_end_curve() {
        switch (this.type) {
            case 5: {
                this.glu_error(100257);
                break;
            }
            default: {
                this.JavaGL.glPushAttrib(73728);
                this.JavaGL.glDisable(3479);
                this.JavaGL.glDisable(3480);
                this.JavaGL.glDisable(3473);
                this.JavaGL.glDisable(3472);
                this.JavaGL.glDisable(3474);
                this.JavaGL.glDisable(3475);
                this.JavaGL.glDisable(3476);
                this.JavaGL.glDisable(3477);
                this.JavaGL.glDisable(3478);
                this.do_curve();
                this.JavaGL.glPopAttrib();
                this.type = 5;
            }
        }
    }

    public void glu_nurbs_curve(int n, float[] fArray, int n2, float[][] fArray2, int n3, int n4) {
        if (this.type == 3 || this.type == 2 || this.type == 4) {
            if (n4 == 3479 || n4 == 3480) {
                this.glu_error(100258);
                return;
            }
        } else if (this.type != 0) {
            this.glu_error(100261);
            return;
        }
        switch (n4) {
            case 3479: 
            case 3480: {
                this.curve.geom.fill(n, fArray, n2, fArray2, n3, n4);
                this.type = 3;
                break;
            }
            case 3472: 
            case 3473: {
                this.curve.color.fill(n, fArray, n2, fArray2, n3, n4);
                break;
            }
            case 3474: {
                this.curve.normal.fill(n, fArray, n2, fArray2, n3, n4);
                break;
            }
            case 3475: 
            case 3476: 
            case 3477: 
            case 3478: {
                this.curve.texture.fill(n, fArray, n2, fArray2, n3, n4);
                break;
            }
            default: {
                this.glu_error(100900);
                return;
            }
        }
    }

    public void glu_begin_surface() {
        switch (this.type) {
            case 5: {
                this.type = 1;
                this.surface.geom.type = 100900;
                this.surface.color.type = 100900;
                this.surface.normal.type = 100900;
                this.surface.texture.type = 100900;
                break;
            }
            case 2: {
                this.glu_error(100266);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.glu_error(100277);
                break;
            }
            case 0: {
                this.glu_error(100256);
            }
        }
    }

    public void glu_end_surface() {
        switch (this.type) {
            case 5: {
                this.glu_error(100263);
                break;
            }
            case 2: {
                this.glu_error(100262);
                break;
            }
            case 3: 
            case 4: {
                this.JavaGL.glPushAttrib(73728);
                this.JavaGL.glDisable(3511);
                this.JavaGL.glDisable(3512);
                this.JavaGL.glDisable(3505);
                this.JavaGL.glDisable(3504);
                this.JavaGL.glDisable(3506);
                this.JavaGL.glDisable(3507);
                this.JavaGL.glDisable(3508);
                this.JavaGL.glDisable(3509);
                this.JavaGL.glDisable(3510);
                this.do_surface();
                this.JavaGL.glPopAttrib();
                break;
            }
            default: {
                this.glu_error(100258);
            }
        }
        this.type = 5;
    }

    public void glu_nurbs_surface(int n, float[] fArray, int n2, float[] fArray2, int n3, int n4, float[][][] fArray3, int n5, int n6, int n7) {
        if (this.type == 3 || this.type == 2 || this.type == 4) {
            if (n7 == 3511 || n7 == 3512) {
                this.glu_error(100258);
                return;
            }
        } else if (this.type != 1) {
            this.glu_error(100261);
            return;
        }
        switch (n7) {
            case 3511: 
            case 3512: {
                this.surface.geom.fill(n, fArray, n2, fArray2, n3, n4, fArray3, n5, n6, n7);
                this.type = 3;
                break;
            }
            case 3504: 
            case 3505: {
                this.surface.color.fill(n, fArray, n2, fArray2, n3, n4, fArray3, n5, n6, n7);
                break;
            }
            case 3506: {
                this.surface.normal.fill(n, fArray, n2, fArray2, n3, n4, fArray3, n5, n6, n7);
                break;
            }
            case 3507: 
            case 3508: 
            case 3509: 
            case 3510: {
                this.surface.texture.fill(n, fArray, n2, fArray2, n3, n4, fArray3, n5, n6, n7);
                break;
            }
            default: {
                this.glu_error(100900);
                return;
            }
        }
    }

    public GLUnurbsObj() {
        System.out.println("Please call new GLUnurbsObj (yourGL, yourGLU)");
    }

    public GLUnurbsObj(GL gL, GLU gLU) {
        this.JavaGL = gL;
        this.JavaGLU = gLU;
        this.JavaGL.glGetIntegerv(2978, this.sampling_viewport);
    }
}

