/*
 * Decompiled with CFR 0.152.
 */
package frams_client_3d;

public class Vector3D {
    private float[] v = new float[]{0.0f, 0.0f, 0.0f};

    public Vector3D(float vx, float vy, float vz) {
        this.v[0] = vx;
        this.v[1] = vy;
        this.v[2] = vz;
    }

    public Vector3D(float[] vector) {
        this.v = vector;
    }

    public Vector3D(Vector3D vector) {
        float[] w = vector.getVector();
        this.v[0] = w[0];
        this.v[1] = w[1];
        this.v[2] = w[2];
    }

    public float[] getVector() {
        return this.v;
    }

    public void rotate(float angle, Vector3D axis) {
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        float[] r = new float[3];
        float[] a = axis.getVector();
        r[0] = (cos + (1.0f - cos) * a[0] * a[0]) * this.v[0];
        r[0] = r[0] + ((1.0f - cos) * a[0] * a[1] - a[2] * sin) * this.v[1];
        r[0] = r[0] + ((1.0f - cos) * a[0] * a[2] + a[1] * sin) * this.v[2];
        r[1] = ((1.0f - cos) * a[0] * a[1] + a[2] * sin) * this.v[0];
        r[1] = r[1] + (cos + (1.0f - cos) * a[1] * a[1]) * this.v[1];
        r[1] = r[1] + ((1.0f - cos) * a[1] * a[2] - a[0] * sin) * this.v[2];
        r[2] = ((1.0f - cos) * a[0] * a[2] - a[1] * sin) * this.v[0];
        r[2] = r[2] + ((1.0f - cos) * a[1] * a[2] + a[0] * sin) * this.v[1];
        r[2] = r[2] + (cos + (1.0f - cos) * a[2] * a[2]) * this.v[2];
        this.v = r;
    }

    public void vectorProduct(Vector3D vector) {
        float[] w = vector.getVector();
        float[] p = new float[]{this.v[1] * w[2] - this.v[2] * w[1], this.v[2] * w[0] - this.v[0] * w[2], this.v[0] * w[1] - this.v[1] * w[0]};
        this.v = p;
    }

    public void normalize() {
        float length = this.length();
        this.v[0] = this.v[0] / length;
        this.v[1] = this.v[1] / length;
        this.v[2] = this.v[2] / length;
    }

    public float length() {
        return (float)Math.sqrt(this.v[0] * this.v[0] + this.v[1] * this.v[1] + this.v[2] * this.v[2]);
    }

    public float scalarProduct(Vector3D vector) {
        float[] w = vector.getVector();
        return this.v[0] * w[0] + this.v[1] * w[1] + this.v[2] * w[2];
    }

    public void mult(float scalar) {
        this.v[0] = this.v[0] * scalar;
        this.v[1] = this.v[1] * scalar;
        this.v[2] = this.v[2] * scalar;
    }
}

