/*
 * Decompiled with CFR 0.152.
 */
package jgl.context.attrib;

import jgl.context.attrib.texture.gl_texture_gen;
import jgl.context.attrib.texture.gl_texture_obj;
import jgl.context.gl_image;
import jgl.context.gl_util;

public class gl_texture {
    public boolean Enable1D = false;
    public boolean Enable2D = false;
    public boolean Enable3D = false;
    public gl_texture_obj Current1D = new gl_texture_obj();
    public gl_texture_obj Current2D = new gl_texture_obj();
    public gl_texture_obj Current3D = new gl_texture_obj();
    public gl_texture_obj CurrentObj;
    public int EnvMode = 8448;
    public float[] EnvColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    public gl_texture_gen CurrentS = new gl_texture_gen();
    public gl_texture_gen CurrentT = new gl_texture_gen();
    public gl_texture_gen CurrentR = new gl_texture_gen();
    public gl_texture_gen CurrentQ = new gl_texture_gen();

    public boolean check_tex() {
        if (this.Enable3D) {
            this.CurrentObj = this.Current3D;
            return true;
        }
        if (this.Enable2D) {
            this.CurrentObj = this.Current2D;
            return true;
        }
        if (this.Enable1D) {
            this.CurrentObj = this.Current1D;
            return true;
        }
        return false;
    }

    public int is_tex_enabled() {
        int n = 0;
        if (this.Enable1D) {
            n |= 1;
        }
        if (this.Enable2D) {
            n |= 2;
        }
        if (this.Enable3D) {
            n |= 4;
        }
        return n;
    }

    public boolean is_tex_enabled(int n) {
        switch (n) {
            case 3552: {
                return this.Enable1D;
            }
            case 3553: {
                return this.Enable2D;
            }
            case 32879: {
                return this.Enable3D;
            }
        }
        return false;
    }

    public boolean tex_enable(int n) {
        this.Enable1D = (n & 1) != 0;
        this.Enable2D = (n & 2) != 0;
        this.Enable3D = (n & 4) != 0;
        return this.check_tex();
    }

    public boolean tex_enable(int n, boolean bl) {
        switch (n) {
            case 3552: {
                this.Enable1D = bl;
                break;
            }
            case 3553: {
                this.Enable2D = bl;
                break;
            }
            case 32879: {
                this.Enable3D = bl;
            }
        }
        return this.check_tex();
    }

    public int is_tex_gen_enabled() {
        int n = 0;
        if (this.CurrentQ.Enable) {
            n |= 1;
        }
        if (this.CurrentR.Enable) {
            n |= 2;
        }
        if (this.CurrentS.Enable) {
            n |= 4;
        }
        if (this.CurrentT.Enable) {
            n |= 8;
        }
        return n;
    }

    public boolean is_tex_gen_enabled(int n) {
        switch (n) {
            case 3171: {
                return this.CurrentQ.Enable;
            }
            case 3170: {
                return this.CurrentR.Enable;
            }
            case 3168: {
                return this.CurrentS.Enable;
            }
            case 3169: {
                return this.CurrentT.Enable;
            }
        }
        return false;
    }

    public void tex_gen_enable(int n) {
        this.CurrentQ.Enable = (n & 1) != 0;
        this.CurrentR.Enable = (n & 2) != 0;
        this.CurrentS.Enable = (n & 4) != 0;
        this.CurrentT.Enable = (n & 8) != 0;
    }

    public void tex_gen_enable(int n, boolean bl) {
        switch (n) {
            case 3171: {
                this.CurrentQ.Enable = bl;
                break;
            }
            case 3170: {
                this.CurrentR.Enable = bl;
                break;
            }
            case 3168: {
                this.CurrentS.Enable = bl;
                break;
            }
            case 3169: {
                this.CurrentT.Enable = bl;
            }
        }
    }

    public void set_tex(int n, int n2, float[] fArray) {
        switch (n) {
            case 3552: {
                this.Current1D.set_tex(n2, fArray);
                break;
            }
            case 3553: {
                this.Current2D.set_tex(n2, fArray);
                break;
            }
            case 32879: {
                this.Current3D.set_tex(n2, fArray);
            }
        }
    }

    public void set_tex_image(int n, int n2, int n3, gl_image gl_image2) {
        switch (n) {
            case 3552: {
                this.Current1D.set_tex_image(n2, n3, gl_image2);
                break;
            }
            case 3553: {
                this.Current2D.set_tex_image(n2, n3, gl_image2);
                break;
            }
            case 32879: {
                this.Current3D.set_tex_image(n2, n3, gl_image2);
            }
        }
    }

    public gl_image get_tex_image(int n, int n2) {
        switch (n) {
            case 3552: {
                return this.Current1D.get_tex_image(n2);
            }
            case 3553: {
                return this.Current2D.get_tex_image(n2);
            }
            case 32879: {
                return this.Current3D.get_tex_image(n2);
            }
        }
        return null;
    }

    public void set_tex_gen_i(int n, int n2) {
        switch (n) {
            case 8195: {
                this.CurrentQ.Mode = n2;
                break;
            }
            case 8194: {
                this.CurrentR.Mode = n2;
                break;
            }
            case 8192: {
                this.CurrentS.Mode = n2;
                break;
            }
            case 8193: {
                this.CurrentT.Mode = n2;
            }
        }
    }

    public void set_tex_gen_f(int n, int n2, float[] fArray) {
        switch (n) {
            case 8195: {
                this.CurrentQ.set_tex_gen(n2, fArray);
                break;
            }
            case 8194: {
                this.CurrentR.set_tex_gen(n2, fArray);
                break;
            }
            case 8192: {
                this.CurrentS.set_tex_gen(n2, fArray);
                break;
            }
            case 8193: {
                this.CurrentT.set_tex_gen(n2, fArray);
            }
        }
    }

    public void bind_texture(int n, gl_texture_obj gl_texture_obj2) {
        switch (n) {
            case 3552: {
                this.Current1D = gl_texture_obj2;
                break;
            }
            case 3553: {
                this.Current2D = gl_texture_obj2;
                break;
            }
            case 32879: {
                this.Current3D = gl_texture_obj2;
            }
        }
        this.check_tex();
    }

    private int get_map_nearest_index(float f, int n, int n2) {
        int n3 = (int)Math.floor(f * (float)(n - 1));
        if (n3 < 0) {
            n3 = 0;
        }
        if (n2 == 10497) {
            n3 &= n - 1;
        } else if (n3 >= n) {
            n3 = n - 1;
        }
        return n3;
    }

    private int tex_map_nearest_1d(float f, int n) {
        gl_image gl_image2 = this.CurrentObj.Image[n].Image;
        int n2 = this.get_map_nearest_index(f, gl_image2.Width, this.CurrentObj.WrapS);
        return 0xFF000000 | (gl_image2.ImageData[n2][0][0][0] & 0xFF) << 16 | (gl_image2.ImageData[n2][0][0][1] & 0xFF) << 8 | gl_image2.ImageData[n2][0][0][2] & 0xFF;
    }

    private int tex_map_nearest_2d(float f, float f2, int n) {
        gl_image gl_image2 = this.CurrentObj.Image[n].Image;
        int n2 = this.get_map_nearest_index(f, gl_image2.Width, this.CurrentObj.WrapS);
        int n3 = this.get_map_nearest_index(f2, gl_image2.Height, this.CurrentObj.WrapT);
        return 0xFF000000 | (gl_image2.ImageData[n2][n3][0][0] & 0xFF) << 16 | (gl_image2.ImageData[n2][n3][0][1] & 0xFF) << 8 | gl_image2.ImageData[n2][n3][0][2] & 0xFF;
    }

    private int tex_map_nearest_3d(float f, float f2, float f3, int n) {
        gl_image gl_image2 = this.CurrentObj.Image[n].Image;
        int n2 = this.get_map_nearest_index(f, gl_image2.Width, this.CurrentObj.WrapS);
        int n3 = this.get_map_nearest_index(f2, gl_image2.Height, this.CurrentObj.WrapT);
        int n4 = this.get_map_nearest_index(f3, gl_image2.Depth, this.CurrentObj.WrapR);
        return 0xFF000000 | (gl_image2.ImageData[n2][n3][n4][0] & 0xFF) << 16 | (gl_image2.ImageData[n2][n3][n4][1] & 0xFF) << 8 | gl_image2.ImageData[n2][n3][n4][2] & 0xFF;
    }

    private float get_map_linear_index(float f, int n, int n2, int[] nArray) {
        float f2 = f * (float)n - 0.5f;
        if (n2 == 10497) {
            nArray[0] = (int)Math.floor(f2) & n - 1;
            nArray[1] = nArray[0] + 1 & n - 1;
        } else {
            nArray[0] = (int)Math.floor(f2);
            if (nArray[0] < 0) {
                nArray[0] = 0;
            }
            if (nArray[0] >= n - 1) {
                nArray[0] = n - 2;
            }
            nArray[1] = nArray[0] + 1;
        }
        return gl_util.frac(f2);
    }

    private int tex_map_linear_1d(float f, int n) {
        gl_image gl_image2 = this.CurrentObj.Image[n].Image;
        int[] nArray = new int[2];
        float f2 = this.get_map_linear_index(f, gl_image2.Width, this.CurrentObj.WrapS, nArray);
        float f3 = 1.0f - f2;
        float f4 = f2;
        int[] nArray2 = new int[]{(int)((float)(gl_image2.ImageData[nArray[0]][0][0][0] & 0xFF) * f3 + (float)(gl_image2.ImageData[nArray[1]][0][0][0] & 0xFF) * f4), (int)((float)(gl_image2.ImageData[nArray[0]][0][0][1] & 0xFF) * f3 + (float)(gl_image2.ImageData[nArray[1]][0][0][1] & 0xFF) * f4), (int)((float)(gl_image2.ImageData[nArray[0]][0][0][2] & 0xFF) * f3 + (float)(gl_image2.ImageData[nArray[1]][0][0][2] & 0xFF) * f4)};
        return gl_util.RGBtoI(nArray2[0], nArray2[1], nArray2[2]);
    }

    private int tex_map_linear_2d(float f, float f2, int n) {
        gl_image gl_image2 = this.CurrentObj.Image[n].Image;
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        float f3 = this.get_map_linear_index(f, gl_image2.Width, this.CurrentObj.WrapS, nArray);
        float f4 = this.get_map_linear_index(f2, gl_image2.Height, this.CurrentObj.WrapT, nArray2);
        float f5 = (1.0f - f3) * (1.0f - f4);
        float f6 = f3 * (1.0f - f4);
        float f7 = (1.0f - f3) * f4;
        float f8 = f3 * f4;
        int[] nArray3 = new int[]{(int)((float)(gl_image2.ImageData[nArray[0]][nArray2[0]][0][0] & 0xFF) * f5 + (float)(gl_image2.ImageData[nArray[1]][nArray2[0]][0][0] & 0xFF) * f6 + (float)(gl_image2.ImageData[nArray[0]][nArray2[1]][0][0] & 0xFF) * f7 + (float)(gl_image2.ImageData[nArray[1]][nArray2[1]][0][0] & 0xFF) * f8), (int)((float)(gl_image2.ImageData[nArray[0]][nArray2[0]][0][1] & 0xFF) * f5 + (float)(gl_image2.ImageData[nArray[1]][nArray2[0]][0][1] & 0xFF) * f6 + (float)(gl_image2.ImageData[nArray[0]][nArray2[1]][0][1] & 0xFF) * f7 + (float)(gl_image2.ImageData[nArray[1]][nArray2[1]][0][1] & 0xFF) * f8), (int)((float)(gl_image2.ImageData[nArray[0]][nArray2[0]][0][2] & 0xFF) * f5 + (float)(gl_image2.ImageData[nArray[1]][nArray2[0]][0][2] & 0xFF) * f6 + (float)(gl_image2.ImageData[nArray[0]][nArray2[1]][0][2] & 0xFF) * f7 + (float)(gl_image2.ImageData[nArray[1]][nArray2[1]][0][2] & 0xFF) * f8)};
        return gl_util.RGBtoI(nArray3[0], nArray3[1], nArray3[2]);
    }

    private int tex_map_linear_3d(float f, float f2, float f3, int n) {
        gl_image gl_image2 = this.CurrentObj.Image[n].Image;
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        float f4 = this.get_map_linear_index(f, gl_image2.Width, this.CurrentObj.WrapS, nArray);
        float f5 = this.get_map_linear_index(f2, gl_image2.Height, this.CurrentObj.WrapT, nArray2);
        float f6 = this.get_map_linear_index(f3, gl_image2.Depth, this.CurrentObj.WrapR, nArray3);
        float f7 = (1.0f - f4) * (1.0f - f5) * (1.0f - f6);
        float f8 = f4 * (1.0f - f5) * (1.0f - f6);
        float f9 = (1.0f - f4) * f5 * (1.0f - f6);
        float f10 = f4 * f5 * (1.0f - f6);
        float f11 = (1.0f - f4) * (1.0f - f5) * f6;
        float f12 = f4 * (1.0f - f5) * f6;
        float f13 = (1.0f - f4) * f5 * f6;
        float f14 = f4 * f5 * f6;
        int[] nArray4 = new int[]{(int)((float)(gl_image2.ImageData[nArray[0]][nArray2[0]][nArray3[0]][0] & 0xFF) * f7 + (float)(gl_image2.ImageData[nArray[1]][nArray2[0]][nArray3[0]][0] & 0xFF) * f8 + (float)(gl_image2.ImageData[nArray[0]][nArray2[1]][nArray3[0]][0] & 0xFF) * f9 + (float)(gl_image2.ImageData[nArray[1]][nArray2[1]][nArray3[0]][0] & 0xFF) * f10 + (float)(gl_image2.ImageData[nArray[0]][nArray2[0]][nArray3[1]][0] & 0xFF) * f11 + (float)(gl_image2.ImageData[nArray[1]][nArray2[0]][nArray3[1]][0] & 0xFF) * f12 + (float)(gl_image2.ImageData[nArray[0]][nArray2[1]][nArray3[1]][0] & 0xFF) * f13 + (float)(gl_image2.ImageData[nArray[1]][nArray2[1]][nArray3[1]][0] & 0xFF) * f14), (int)((float)(gl_image2.ImageData[nArray[0]][nArray2[0]][nArray3[0]][1] & 0xFF) * f7 + (float)(gl_image2.ImageData[nArray[1]][nArray2[0]][nArray3[0]][1] & 0xFF) * f8 + (float)(gl_image2.ImageData[nArray[0]][nArray2[1]][nArray3[0]][1] & 0xFF) * f9 + (float)(gl_image2.ImageData[nArray[1]][nArray2[1]][nArray3[0]][1] & 0xFF) * f10 + (float)(gl_image2.ImageData[nArray[0]][nArray2[0]][nArray3[1]][1] & 0xFF) * f11 + (float)(gl_image2.ImageData[nArray[1]][nArray2[0]][nArray3[1]][1] & 0xFF) * f12 + (float)(gl_image2.ImageData[nArray[0]][nArray2[1]][nArray3[1]][1] & 0xFF) * f13 + (float)(gl_image2.ImageData[nArray[1]][nArray2[1]][nArray3[1]][1] & 0xFF) * f14), (int)((float)(gl_image2.ImageData[nArray[0]][nArray2[0]][nArray3[0]][2] & 0xFF) * f7 + (float)(gl_image2.ImageData[nArray[1]][nArray2[0]][nArray3[0]][2] & 0xFF) * f8 + (float)(gl_image2.ImageData[nArray[0]][nArray2[1]][nArray3[0]][2] & 0xFF) * f9 + (float)(gl_image2.ImageData[nArray[1]][nArray2[1]][nArray3[0]][2] & 0xFF) * f10 + (float)(gl_image2.ImageData[nArray[0]][nArray2[0]][nArray3[1]][2] & 0xFF) * f11 + (float)(gl_image2.ImageData[nArray[1]][nArray2[0]][nArray3[1]][2] & 0xFF) * f12 + (float)(gl_image2.ImageData[nArray[0]][nArray2[1]][nArray3[1]][2] & 0xFF) * f13 + (float)(gl_image2.ImageData[nArray[1]][nArray2[1]][nArray3[1]][2] & 0xFF) * f14)};
        return gl_util.RGBtoI(nArray4[0], nArray4[1], nArray4[2]);
    }

    private int tex_map(float f, float f2, float f3) {
        if (this.CurrentObj.MagFilter == 9728) {
            if (this.Enable3D) {
                return this.tex_map_nearest_3d(f, f2, f3, 0);
            }
            if (this.Enable2D) {
                return this.tex_map_nearest_2d(f, f2, 0);
            }
            if (this.Enable1D) {
                return this.tex_map_nearest_1d(f, 0);
            }
        } else {
            if (this.Enable3D) {
                return this.tex_map_linear_3d(f, f2, f3, 0);
            }
            if (this.Enable2D) {
                return this.tex_map_linear_2d(f, f2, 0);
            }
            if (this.Enable1D) {
                return this.tex_map_linear_1d(f, 0);
            }
        }
        return 0;
    }

    private int tex_mid_nearest_nearest(float f, float f2, float f3, float f4) {
        int n;
        if ((double)f4 <= 0.5) {
            n = 0;
        } else {
            n = (int)((double)f4 + 0.499999);
            if (n > this.CurrentObj.Image[0].WidthLog2) {
                n = this.CurrentObj.Image[0].WidthLog2;
            }
        }
        if (this.Enable3D) {
            return this.tex_map_nearest_3d(f, f2, f3, n);
        }
        if (this.Enable2D) {
            return this.tex_map_nearest_2d(f, f2, n);
        }
        if (this.Enable1D) {
            return this.tex_map_nearest_1d(f, n);
        }
        return 0;
    }

    private int tex_mid_linear_nearest(float f, float f2, float f3, float f4) {
        int n;
        if ((double)f4 <= 0.5) {
            n = 0;
        } else {
            n = (int)((double)f4 + 0.499999);
            if (n > this.CurrentObj.Image[0].WidthLog2) {
                n = this.CurrentObj.Image[0].WidthLog2;
            }
        }
        if (this.Enable3D) {
            return this.tex_map_linear_3d(f, f2, f3, n);
        }
        if (this.Enable2D) {
            return this.tex_map_linear_2d(f, f2, n);
        }
        if (this.Enable1D) {
            return this.tex_map_linear_1d(f, n);
        }
        return 0;
    }

    private int get_mid_linear_color(int n, int n2, float f) {
        float f2 = gl_util.frac(f);
        int[][] nArray = new int[2][3];
        nArray[0][2] = n & 0xFF0000;
        nArray[0][1] = n & 0xFF00;
        nArray[0][0] = n & 0xFF;
        nArray[1][2] = n2 & 0xFF0000;
        nArray[1][1] = n2 & 0xFF00;
        nArray[1][0] = n2 & 0xFF;
        nArray[0][0] = (int)((float)nArray[1][0] * (1.0f - f2) + (float)nArray[0][0] * f2);
        nArray[0][1] = (int)((float)nArray[1][1] * (1.0f - f2) + (float)nArray[0][1] * f2);
        nArray[0][2] = (int)((float)nArray[1][2] * (1.0f - f2) + (float)nArray[0][2] * f2);
        return gl_util.RGBtoI(nArray[0][0], nArray[0][1], nArray[0][2]);
    }

    private int tex_mid_nearest_linear_1d(float f, float f2) {
        int n = this.CurrentObj.Image[0].MaxLog2;
        if (f2 >= (float)n) {
            return this.tex_map_nearest_1d(f, n);
        }
        int n2 = (int)((double)f2 + 1.0);
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > n) {
            n2 = n;
        }
        return this.get_mid_linear_color(this.tex_map_nearest_1d(f, n2 - 1), this.tex_map_nearest_1d(f, n2), f2);
    }

    private int tex_mid_nearest_linear_2d(float f, float f2, float f3) {
        int n = this.CurrentObj.Image[0].MaxLog2;
        if (f3 >= (float)n) {
            return this.tex_map_nearest_2d(f, f2, n);
        }
        int n2 = (int)((double)f3 + 1.0);
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > n) {
            n2 = n;
        }
        return this.get_mid_linear_color(this.tex_map_nearest_2d(f, f2, n2 - 1), this.tex_map_nearest_2d(f, f2, n2), f3);
    }

    private int tex_mid_nearest_linear_3d(float f, float f2, float f3, float f4) {
        int n = this.CurrentObj.Image[0].MaxLog2;
        if (f4 >= (float)n) {
            return this.tex_map_nearest_3d(f, f2, f3, n);
        }
        int n2 = (int)((double)f4 + 1.0);
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > n) {
            n2 = n;
        }
        return this.get_mid_linear_color(this.tex_map_nearest_3d(f, f2, f3, n2 - 1), this.tex_map_nearest_3d(f, f2, f3, n2), f4);
    }

    private int tex_mid_linear_linear_1d(float f, float f2) {
        int n = this.CurrentObj.Image[0].MaxLog2;
        if (f2 >= (float)n) {
            return this.tex_map_linear_1d(f, n);
        }
        int n2 = (int)((double)f2 + 1.0);
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > n) {
            n2 = n;
        }
        return this.get_mid_linear_color(this.tex_map_linear_1d(f, n2 - 1), this.tex_map_linear_1d(f, n2), f2);
    }

    private int tex_mid_linear_linear_2d(float f, float f2, float f3) {
        int n = this.CurrentObj.Image[0].MaxLog2;
        if (f3 >= (float)n) {
            return this.tex_map_linear_2d(f, f2, n);
        }
        int n2 = (int)((double)f3 + 1.0);
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > n) {
            n2 = n;
        }
        return this.get_mid_linear_color(this.tex_map_linear_2d(f, f2, n2 - 1), this.tex_map_linear_2d(f, f2, n2), f3);
    }

    private int tex_mid_linear_linear_3d(float f, float f2, float f3, float f4) {
        int n = this.CurrentObj.Image[0].MaxLog2;
        if (f4 >= (float)n) {
            return this.tex_map_linear_3d(f, f2, f3, n);
        }
        int n2 = (int)((double)f4 + 1.0);
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > n) {
            n2 = n;
        }
        return this.get_mid_linear_color(this.tex_map_linear_3d(f, f2, f3, n2 - 1), this.tex_map_linear_3d(f, f2, f3, n2), f4);
    }

    private int tex_mid(float f, float f2, float f3, float f4) {
        float f5 = this.CurrentObj.MagFilter == 9729 && (this.CurrentObj.MinFilter == 9984 || this.CurrentObj.MinFilter == 9985) ? 0.5f : 0.0f;
        if (f4 > f5) {
            switch (this.CurrentObj.MinFilter) {
                case 9984: {
                    return this.tex_mid_nearest_nearest(f, f2, f3, f4);
                }
                case 9985: {
                    return this.tex_mid_linear_nearest(f, f2, f3, f4);
                }
                case 9986: {
                    if (this.Enable3D) {
                        return this.tex_mid_nearest_linear_3d(f, f2, f3, f4);
                    }
                    if (this.Enable2D) {
                        return this.tex_mid_nearest_linear_2d(f, f2, f4);
                    }
                    if (this.Enable1D) {
                        return this.tex_mid_nearest_linear_1d(f, f4);
                    }
                }
                case 9987: {
                    if (this.Enable3D) {
                        this.tex_mid_linear_linear_3d(f, f2, f3, f4);
                    }
                    if (this.Enable2D) {
                        this.tex_mid_linear_linear_2d(f, f2, f4);
                    }
                    if (!this.Enable1D) break;
                    this.tex_mid_linear_linear_1d(f, f4);
                }
            }
            return 0;
        }
        return this.tex_map(f, f2, f3);
    }

    private float lambda(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f2 < 0.0f ? -f2 : f2;
        float f9 = f3 < 0.0f ? -f3 : f3;
        float f10 = f4 < 0.0f ? -f4 : f4;
        float f11 = f5 < 0.0f ? -f5 : f5;
        float f12 = f6 < 0.0f ? -f6 : f6;
        float f13 = f7 < 0.0f ? -f7 : f7;
        float f14 = Math.max(f8, f9) * (float)this.CurrentObj.Image[0].Width;
        float f15 = Math.max(f10, f11) * (float)this.CurrentObj.Image[0].Height;
        float f16 = Math.max(f12, f13) * (float)this.CurrentObj.Image[0].Depth;
        float f17 = Math.max(Math.max(f14, f15), f16) / f;
        if (f17 < 0.0f) {
            f17 = -f17;
        }
        if (f17 == 0.0f) {
            return 0.0f;
        }
        return (float)(Math.log(f17) * 1.442695);
    }

    public int tex_vertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        if (this.CurrentObj.MinFilter == 9728 || this.CurrentObj.MinFilter == 9729) {
            return this.tex_map(f, f2, f3);
        }
        return this.tex_mid(f, f2, f3, this.lambda(f4, f5, f6, f7, f8, f9, f10));
    }

    public int tex_vertex(float f, float f2, float f3) {
        return this.tex_map(f, f2, f3);
    }

    public float[] get_tex_gen_coord(float[] fArray, float[] fArray2, float[] fArray3) {
        float[] fArray4 = new float[]{this.CurrentS.Enable ? this.CurrentS.get_tex_gen_coord(fArray, fArray2, fArray3) : 0.0f, this.CurrentT.Enable ? this.CurrentT.get_tex_gen_coord(fArray, fArray2, fArray3) : 0.0f, this.CurrentR.Enable ? this.CurrentR.get_tex_gen_coord(fArray, fArray2) : 0.0f, this.CurrentQ.Enable ? this.CurrentQ.get_tex_gen_coord(fArray, fArray2) : 1.0f};
        return fArray4;
    }
}

