/*
 * Decompiled with CFR 0.152.
 */
package frams_client_3d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class StatusBar
extends JScrollPane {
    private SimpleAttributeSet[] attributes = null;
    private JTextPane jTextPane = null;
    private StyledDocument doc = null;
    public static int DEFAULT = 0;
    public static int WARNING = 1;
    public static int ERROR = 2;
    public static int INFO = 3;

    public StatusBar() {
        this.initialize();
    }

    private void initialize() {
        this.setViewportView(this.getJTextPane());
        this.setVerticalScrollBarPolicy(22);
        this.setWheelScrollingEnabled(true);
        this.getVerticalScrollBar().setUnitIncrement(16);
        this.setAutoscrolls(true);
        Dimension size = this.jTextPane.getPreferredSize();
        this.setMinimumSize(size);
        this.initAttributes();
    }

    private JTextPane getJTextPane() {
        if (this.jTextPane == null) {
            this.jTextPane = new JTextPane();
            this.jTextPane.setCaretPosition(0);
            this.jTextPane.setMargin(new Insets(0, 5, 0, 5));
            this.jTextPane.setPreferredSize(new Dimension(480, 36));
            this.jTextPane.setEditable(false);
            this.doc = this.jTextPane.getStyledDocument();
        }
        return this.jTextPane;
    }

    private void initAttributes() {
        if (this.attributes == null) {
            this.attributes = new SimpleAttributeSet[4];
            this.attributes[0] = new SimpleAttributeSet();
            StyleConstants.setFontFamily(this.attributes[0], "SansSerif");
            StyleConstants.setFontSize(this.attributes[0], 12);
            this.attributes[1] = new SimpleAttributeSet(this.attributes[0]);
            StyleConstants.setForeground(this.attributes[1], Color.red);
            this.attributes[2] = new SimpleAttributeSet(this.attributes[1]);
            StyleConstants.setBold(this.attributes[2], true);
            this.attributes[3] = new SimpleAttributeSet(this.attributes[0]);
            StyleConstants.setForeground(this.attributes[3], Color.blue);
            StyleConstants.setItalic(this.attributes[3], true);
        }
    }

    public void addMessage(String text, int type) {
        try {
            this.doc.insertString(this.doc.getLength(), String.valueOf(text) + "\n", this.attributes[type]);
            Rectangle rect = new Rectangle(0, this.jTextPane.getHeight() - 17, this.jTextPane.getWidth(), this.jTextPane.getHeight());
            this.jTextPane.scrollRectToVisible(rect);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

