/*
 * Decompiled with CFR 0.152.
 */
package frams_client_3d;

import foxtrot.Task;
import foxtrot.Worker;
import frams_client_3d.Communication;
import frams_client_3d.CommunicationErrorException;
import frams_client_3d.Creature;
import frams_client_3d.Log;
import frams_client_3d.Options;
import frams_client_3d.StatusBar;
import frams_client_3d.ViewGL;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class MainWindow
extends JFrame {
    private Communication comm = new Communication();
    private Log networkLogs = null;
    private boolean listening = false;
    private boolean showSelected = true;
    private ArrayList creatureEvents = new ArrayList();
    private String messageEvent = null;
    private String runningEvent = null;
    private String groupEvent = null;
    private Vector creaturesCount = new Vector();
    private ArrayList groups = new ArrayList();
    private ArrayList creatures = new ArrayList();
    private ArrayList messages = new ArrayList();
    private boolean running;
    private JPanel jContentPane = null;
    private JSplitPane jSplitPane = null;
    private JSplitPane jSplitPane1 = null;
    private Options options = null;
    private ViewGL viewGL = null;
    private StatusBar statusBar = null;

    public static void main(String[] args) {
        MainWindow frame = new MainWindow();
        while (true) {
            if (frame.isListening()) {
                Object data = null;
                try {
                    if (frame.getMessages()) {
                        Runnable runUpdateMessages = new Runnable(){

                            public void run() {
                                MainWindow.this.updateMessages();
                            }
                        };
                        SwingUtilities.invokeLater(runUpdateMessages);
                    }
                    if (frame.getChangedGroups() || frame.getChangedCreatures()) {
                        Runnable runUpdateTree = new Runnable(){

                            public void run() {
                                MainWindow.this.updateTree();
                            }
                        };
                        SwingUtilities.invokeLater(runUpdateTree);
                    }
                    if (!frame.getChangedRunningState()) continue;
                    Runnable runUpdateRunningState = new Runnable(){

                        public void run() {
                            MainWindow.this.updateRunningState();
                        }
                    };
                    SwingUtilities.invokeLater(runUpdateRunningState);
                }
                catch (IOException e) {
                    frame.handleIOException(e);
                }
                catch (CommunicationErrorException e) {
                    frame.handleCommunicationErrorException(e);
                }
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public MainWindow() {
        this.initialize();
        this.setDefaultCloseOperation(3);
        this.statusBar.addMessage("Application started.", StatusBar.DEFAULT);
    }

    private void initialize() {
        this.setSize(640, 480);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Frams Client 3D");
        this.setVisible(true);
        this.networkLogs = new Log();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJSplitPane(), "Center");
        }
        return this.jContentPane;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOrientation(0);
            this.jSplitPane.setTopComponent(this.getJSplitPane1());
            this.jSplitPane.setBottomComponent(this.getStatusBar());
            this.jSplitPane.setOneTouchExpandable(true);
            this.jSplitPane.setContinuousLayout(true);
            this.jSplitPane.setDividerSize(8);
            this.jSplitPane.setResizeWeight(1.0);
        }
        return this.jSplitPane;
    }

    private JSplitPane getJSplitPane1() {
        if (this.jSplitPane1 == null) {
            this.jSplitPane1 = new JSplitPane();
            this.jSplitPane1.setOrientation(1);
            this.jSplitPane1.setLeftComponent(this.getOptions());
            this.jSplitPane1.setRightComponent(this.getViewGL());
            this.jSplitPane1.setOneTouchExpandable(true);
            this.jSplitPane1.setContinuousLayout(true);
            this.jSplitPane1.setDividerSize(8);
            this.jSplitPane1.setResizeWeight(0.0);
            this.jSplitPane1.setBorder(null);
        }
        return this.jSplitPane1;
    }

    public Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
            this.options.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("connected")) {
                        MainWindow.this.connect(e.getNewValue());
                    } else if (e.getPropertyName().equals("started")) {
                        MainWindow.this.startSimulation();
                    } else if (e.getPropertyName().equals("stopped")) {
                        MainWindow.this.stopSimulation();
                    } else if (e.getPropertyName().equals("logs")) {
                        MainWindow.this.networkLogs.setVisible(true);
                    } else if (e.getPropertyName().equals("tree")) {
                        MainWindow.this.passObjectsToView();
                    } else if (e.getPropertyName().equals("show")) {
                        MainWindow.this.showSelected = e.getNewValue().toString().equals("true");
                        MainWindow.this.passObjectsToView();
                    }
                }
            });
        }
        return this.options;
    }

    private StatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new StatusBar();
        }
        return this.statusBar;
    }

    private ViewGL getViewGL() {
        if (this.viewGL == null) {
            this.viewGL = new ViewGL();
            this.viewGL.init();
        }
        return this.viewGL;
    }

    private void connect(Object value) {
        if (value.toString().equals("true")) {
            try {
                Worker.post((Task)new Task(){

                    public Object run() throws IOException {
                        MainWindow.this.comm.connect(MainWindow.this.options.getIp(), MainWindow.this.options.getPort());
                        return null;
                    }
                });
            }
            catch (Exception e) {
                this.statusBar.addMessage("Couldn't get I/O for the connection to a server at " + this.options.getIp(), StatusBar.ERROR);
                this.options.setConnected(false);
                return;
            }
            this.statusBar.addMessage("Connected.", StatusBar.DEFAULT);
            this.networkLogs.addLogLine("[" + this.options.getIp() + "]", Color.black);
            this.readInitialData();
        } else {
            try {
                this.comm.disconnect();
                this.options.setConnected(false);
                this.statusBar.addMessage("Disconnected.", StatusBar.DEFAULT);
                this.networkLogs.addLogLine("---", Color.blue);
                this.setListening(false);
                this.creatureEvents.clear();
                this.messageEvent = null;
                this.runningEvent = null;
            }
            catch (IOException e) {
                this.statusBar.addMessage("Stream closing error: " + e.getMessage(), StatusBar.ERROR);
                return;
            }
        }
        this.updateLog();
    }

    private void readInitialData() {
        this.statusBar.addMessage("Reading heighfield...", StatusBar.INFO);
        ArrayList[] heighfield = null;
        try {
            heighfield = (ArrayList[])Worker.post((Task)new Task(){

                public Object run() throws IOException, CommunicationErrorException {
                    MainWindow.this.registerOnMessages();
                    MainWindow.this.registerOnRunningChanged();
                    return MainWindow.this.readHeighfield();
                }
            });
        }
        catch (IOException e) {
            this.handleIOException(e);
            return;
        }
        catch (CommunicationErrorException e) {
            this.handleCommunicationErrorException(e);
            return;
        }
        catch (Exception e) {
            this.handleException(e);
            return;
        }
        this.viewGL.setHeighfield(heighfield[0], heighfield[1]);
        this.statusBar.addMessage("Heighfield set.", StatusBar.DEFAULT);
        this.updateLog();
        this.statusBar.addMessage("Reading creatures tree...", StatusBar.INFO);
        DefaultTreeModel treeModel = null;
        try {
            treeModel = (DefaultTreeModel)Worker.post((Task)new Task(){

                public Object run() throws IOException, CommunicationErrorException {
                    return MainWindow.this.buildTree();
                }
            });
        }
        catch (IOException e) {
            this.handleIOException(e);
            return;
        }
        catch (CommunicationErrorException e) {
            this.handleCommunicationErrorException(e);
            return;
        }
        catch (Exception e) {
            this.handleException(e);
            return;
        }
        this.options.setTree(treeModel);
        this.statusBar.addMessage("Creatures tree set.", StatusBar.DEFAULT);
        this.updateLog();
        this.statusBar.addMessage("Reading simulation state...", StatusBar.INFO);
        Integer isRunning = null;
        try {
            isRunning = (Integer)Worker.post((Task)new Task(){

                public Object run() throws IOException, CommunicationErrorException {
                    MainWindow.this.registerOnGroupsChanged();
                    return MainWindow.this.readRunningState();
                }
            });
        }
        catch (IOException e) {
            this.handleIOException(e);
            return;
        }
        catch (CommunicationErrorException e) {
            this.handleCommunicationErrorException(e);
            return;
        }
        catch (Exception e) {
            this.handleException(e);
            return;
        }
        this.running = isRunning == 1;
        this.updateRunningState();
        this.setListening(true);
    }

    private void handleIOException(IOException e) {
        this.statusBar.addMessage("I/O error: " + e.getMessage(), StatusBar.ERROR);
        this.updateLog();
        this.connect("false");
    }

    private void handleCommunicationErrorException(CommunicationErrorException e) {
        this.statusBar.addMessage("protocol error: " + e.getMessage(), StatusBar.WARNING);
        this.updateLog();
    }

    private void handleException(Exception e) {
        this.statusBar.addMessage("unexpected exception: " + e.getMessage(), StatusBar.ERROR);
        this.updateLog();
        this.connect("false");
    }

    private void startSimulation() {
        String request = "set /simulator running 1";
        try {
            this.sendRequest(request);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return;
        }
        catch (CommunicationErrorException e) {
            this.handleCommunicationErrorException(e);
            return;
        }
        this.updateLog();
    }

    private void stopSimulation() {
        String request = "set /simulator running 0";
        try {
            this.sendRequest(request);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return;
        }
        catch (CommunicationErrorException e) {
            this.handleCommunicationErrorException(e);
            return;
        }
        this.updateLog();
    }

    private Integer readRunningState() throws IOException, CommunicationErrorException {
        String line = null;
        String request = null;
        ArrayList response = null;
        String state = null;
        request = "get /simulator running";
        response = this.sendRequest(request);
        int i = 0;
        while (i < response.size()) {
            line = response.get(i).toString();
            if (line.startsWith("running")) {
                state = line.substring(line.indexOf(58) + 1);
                break;
            }
            ++i;
        }
        return Integer.valueOf(state);
    }

    private ArrayList[] readHeighfield() throws IOException, CommunicationErrorException {
        String line = null;
        String request = null;
        ArrayList response = null;
        int state = 0;
        ArrayList[] heighfield = new ArrayList[2];
        ArrayList<String[]> points = new ArrayList<String[]>();
        ArrayList<String[]> faces = new ArrayList<String[]>();
        request = "get /simulator/world faces";
        response = this.sendRequest(request);
        int i = 0;
        while (i < response.size()) {
            line = response.get(i).toString();
            if (line.startsWith("p")) {
                state = 1;
            } else if (line.startsWith("f") && 1 == state) {
                state = 2;
            } else {
                String[] parse;
                if (line.startsWith("~")) break;
                if (1 == state) {
                    parse = line.split(" ");
                    points.add(parse);
                }
                if (2 == state) {
                    parse = line.split(" ");
                    faces.add(parse);
                }
            }
            ++i;
        }
        heighfield[0] = points;
        heighfield[1] = faces;
        return heighfield;
    }

    private DefaultTreeModel buildTree() throws IOException, CommunicationErrorException {
        String line = null;
        String request = null;
        ArrayList response = null;
        String name = null;
        this.creaturesCount.clear();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("world");
        request = "get /simulator/populations/groups name,creatures";
        response = this.sendRequest(request);
        int i = 0;
        while (i < response.size()) {
            line = response.get(i).toString();
            if (line.startsWith("name")) {
                name = line.substring(line.indexOf(58) + 1);
            } else if (line.startsWith("creatures")) {
                Integer number = Integer.valueOf(line.substring(line.indexOf(58) + 1));
                this.creaturesCount.add(number);
                if (number > 0) {
                    rootNode.add(new DefaultMutableTreeNode(name));
                } else {
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
                    rootNode.add(node);
                    node.add(new DefaultMutableTreeNode("[empty]"));
                }
            }
            ++i;
        }
        i = 0;
        while (i < rootNode.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            int count = (Integer)this.creaturesCount.get(i);
            int j = 0;
            while (j < count) {
                Creature creature = this.readCreature(i, j);
                node.add(new DefaultMutableTreeNode(creature));
                ++j;
            }
            this.registerOnCreaturesChanged(i, true);
            ++i;
        }
        return new DefaultTreeModel(rootNode);
    }

    private Creature readCreature(int group, int index) throws IOException, CommunicationErrorException {
        int partsCount = 0;
        int jointsCount = 0;
        String name = null;
        String genotype = null;
        String line = null;
        String request = null;
        ArrayList response = null;
        String requestPrefix = "get /simulator/populations/groups/" + group + "/creatures/" + index;
        request = String.valueOf(requestPrefix) + " name,genotype,parts,joints";
        response = this.sendRequest(request);
        int k = 0;
        while (k < response.size()) {
            line = response.get(k).toString();
            if (line.startsWith("name")) {
                name = line.substring(line.indexOf(58) + 1);
            } else if (line.startsWith("genotype")) {
                genotype = line.substring(line.indexOf(58) + 1);
            } else if (line.startsWith("parts")) {
                partsCount = Integer.parseInt(line.substring(line.indexOf(58) + 1));
            } else if (line.startsWith("joints")) {
                jointsCount = Integer.parseInt(line.substring(line.indexOf(58) + 1));
            }
            ++k;
        }
        Creature creature = new Creature(name, genotype, partsCount, jointsCount, group, index);
        int p1 = 0;
        int p2 = 0;
        request = String.valueOf(requestPrefix) + "/joints p1,p2";
        response = this.sendRequest(request);
        int k2 = 0;
        while (k2 < response.size()) {
            line = response.get(k2).toString();
            if (line.startsWith("p1")) {
                p1 = Integer.parseInt(line.substring(line.indexOf(58) + 1));
            } else if (line.startsWith("p2")) {
                p2 = Integer.parseInt(line.substring(line.indexOf(58) + 1));
                creature.addJoint(p1, p2);
            }
            ++k2;
        }
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        request = String.valueOf(requestPrefix) + "/mechparts x,y,z";
        response = this.sendRequest(request);
        int k3 = 0;
        while (k3 < response.size()) {
            line = response.get(k3).toString();
            if (line.startsWith("x")) {
                x = Float.parseFloat(line.substring(line.indexOf(58) + 1));
            } else if (line.startsWith("y")) {
                y = Float.parseFloat(line.substring(line.indexOf(58) + 1));
            } else if (line.startsWith("z")) {
                z = Float.parseFloat(line.substring(line.indexOf(58) + 1));
                creature.addPart(x, y, z);
            }
            ++k3;
        }
        return creature;
    }

    private String readGroup(int index) throws IOException, CommunicationErrorException {
        String name = null;
        String line = null;
        String request = null;
        ArrayList response = null;
        request = "get /simulator/populations/groups/" + index + " name";
        response = this.sendRequest(request);
        int k = 0;
        while (k < response.size()) {
            line = response.get(k).toString();
            if (line.startsWith("name")) {
                name = line.substring(line.indexOf(58) + 1);
                break;
            }
            ++k;
        }
        return name;
    }

    private void registerOnMessages() throws IOException, CommunicationErrorException {
        String request = "reg /cli/messages 1";
        ArrayList response = this.sendRequest(request);
        String[] parse = response.get(0).toString().split("  ");
        this.messageEvent = parse[1];
    }

    private void registerOnCreaturesChanged(int group, boolean isAdd) throws IOException, CommunicationErrorException {
        String request = "reg /simulator/populations/groups/" + group + "/creatures_changed 1";
        ArrayList response = this.sendRequest(request);
        String[] parse = response.get(0).toString().split("  ");
        if (isAdd) {
            this.creatureEvents.add(group, parse[1]);
        } else {
            this.creatureEvents.set(group, parse[1]);
        }
    }

    private void registerOnRunningChanged() throws IOException, CommunicationErrorException {
        String request = "reg /simulator/running_changed 1";
        ArrayList response = this.sendRequest(request);
        String[] parse = response.get(0).toString().split("  ");
        this.runningEvent = parse[1];
    }

    private void registerOnGroupsChanged() throws IOException, CommunicationErrorException {
        String request = "reg /simulator/populations/groups_changed 1";
        ArrayList response = this.sendRequest(request);
        String[] parse = response.get(0).toString().split("  ");
        this.groupEvent = parse[1];
    }

    private ArrayList sendRequest(String request) throws IOException, CommunicationErrorException {
        this.comm.sendMessage(request);
        ArrayList respond = null;
        try {
            respond = this.comm.readMessage();
        }
        catch (InterruptedException e) {
            return new ArrayList();
        }
        return respond;
    }

    public void updateLog() {
        ArrayList log = this.comm.getLog();
        int i = 0;
        while (i < log.size()) {
            String line = log.get(i).toString();
            if (line.startsWith("> ")) {
                this.networkLogs.addLogLine(line, Color.gray);
            } else {
                this.networkLogs.addLogLine(line, Color.darkGray);
            }
            ++i;
        }
        log.clear();
    }

    public void passObjectsToView() {
        if (this.showSelected) {
            this.viewGL.setCreatures(this.options.getSelection());
        } else {
            this.viewGL.setCreatures(this.options.getAllCreatures());
        }
    }

    public synchronized boolean isListening() {
        return this.listening;
    }

    public synchronized void setListening(boolean state) {
        this.listening = state;
    }

    public boolean getChangedCreatures() throws IOException, CommunicationErrorException {
        String line = null;
        String request = null;
        ArrayList response = null;
        int i = 0;
        while (i < this.creatureEvents.size()) {
            Integer type = null;
            Integer group = null;
            request = "call " + this.creatureEvents.get(i) + " sendall";
            response = this.sendRequest(request);
            int k = 0;
            while (k < response.size()) {
                line = response.get(k).toString();
                if (line.startsWith("event")) {
                    String[] parse = line.split(" ");
                    parse = parse[2].split("/");
                    group = Integer.valueOf(parse[4]);
                } else if (line.startsWith("type")) {
                    type = Integer.valueOf(line.substring(line.indexOf(58) + 1));
                    this.creatures.add(type);
                } else if (line.startsWith("pos")) {
                    Creature creature;
                    int position = Integer.parseInt(line.substring(line.indexOf(58) + 1));
                    if (1 == type) {
                        creature = new Creature(null, null, 0, 0, group, position);
                        this.creatures.add(creature);
                    } else {
                        creature = this.readCreature(group, position);
                        this.creatures.add(creature);
                    }
                }
                ++k;
            }
            ++i;
        }
        return this.creatures.size() > 0;
    }

    public boolean getMessages() throws IOException, CommunicationErrorException {
        String line = null;
        String request = null;
        ArrayList response = null;
        String buffer = null;
        request = "call " + this.messageEvent + " sendall";
        response = this.sendRequest(request);
        int k = 0;
        while (k < response.size()) {
            line = response.get(k).toString();
            if (line.startsWith("class")) {
                buffer = String.valueOf(line.substring(line.indexOf(58) + 1)) + "::";
            } else if (line.startsWith("function")) {
                buffer = String.valueOf(buffer) + line.substring(line.indexOf(58) + 1) + " - ";
            } else if (line.startsWith("message")) {
                this.messages.add(String.valueOf(buffer) + line.substring(line.indexOf(58) + 1));
            } else if (line.startsWith("level")) {
                this.messages.add(Integer.valueOf(line.substring(line.indexOf(58) + 1)));
            }
            ++k;
        }
        return this.messages.size() > 0;
    }

    public boolean getChangedRunningState() throws IOException, CommunicationErrorException {
        String line = null;
        String request = null;
        ArrayList response = null;
        String value = null;
        request = "call " + this.runningEvent + " sendall";
        response = this.sendRequest(request);
        int k = 0;
        while (k < response.size()) {
            line = response.get(k).toString();
            if (line.startsWith("value")) {
                value = line.substring(line.indexOf(58) + 1);
                this.running = value.equals("1");
            }
            ++k;
        }
        return value != null;
    }

    public boolean getChangedGroups() throws IOException, CommunicationErrorException {
        String line = null;
        String request = null;
        ArrayList response = null;
        Integer type = null;
        String name = null;
        request = "call " + this.groupEvent + " sendall";
        response = this.sendRequest(request);
        int k = 0;
        while (k < response.size()) {
            line = response.get(k).toString();
            if (line.startsWith("type")) {
                type = Integer.valueOf(line.substring(line.indexOf(58) + 1));
                this.groups.add(type);
            } else if (line.startsWith("pos")) {
                Integer position = Integer.valueOf(line.substring(line.indexOf(58) + 1));
                this.groups.add(position);
                if (type == 0) {
                    name = this.readGroup(position);
                    this.registerOnCreaturesChanged(position, true);
                    this.creaturesCount.add(position, new Integer(0));
                } else if (1 == type) {
                    name = null;
                    this.creatureEvents.remove(position);
                    this.creaturesCount.removeElementAt(position);
                } else if (2 == type) {
                    name = this.readGroup(position);
                    this.registerOnCreaturesChanged(position, false);
                }
                this.groups.add(name);
            }
            ++k;
        }
        return this.groups.size() > 0;
    }

    public void updateTree() {
        Integer type;
        this.updateLog();
        int i = 0;
        while (i < this.groups.size()) {
            type = (Integer)this.groups.get(i);
            Integer position = (Integer)this.groups.get(i + 1);
            String name = (String)this.groups.get(i + 2);
            this.updateGroup(type, position, name);
            i += 3;
        }
        this.groups.clear();
        i = 0;
        while (i < this.creatures.size()) {
            type = (Integer)this.creatures.get(i);
            Creature creature = (Creature)this.creatures.get(i + 1);
            this.updateCreature(type, creature);
            i += 2;
        }
        this.creatures.clear();
        this.passObjectsToView();
    }

    private void updateGroup(int type, int position, String name) {
        if (type == 0) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
            Integer n = (Integer)this.creaturesCount.get(position);
            if (n == 0) {
                node.add(new DefaultMutableTreeNode("[empty]"));
            }
            this.getOptions().addTreeNode(node, position);
        } else if (1 == type) {
            this.getOptions().removeTreeNode(position);
        } else if (2 == type) {
            this.updateGroup(1, position, name);
            this.updateGroup(0, position, name);
        }
    }

    private void updateCreature(int type, Creature creature) {
        if (type == 0) {
            Integer n = (Integer)this.creaturesCount.get(creature.getGroup());
            if (n == 0) {
                this.getOptions().removeTreeNode(creature.getGroup(), 0);
                this.creaturesCount.set(creature.getGroup(), new Integer(1));
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(creature);
            this.getOptions().addTreeNode(node, creature.getGroup(), creature.getIndex());
        } else if (1 == type) {
            this.getOptions().removeTreeNode(creature.getGroup(), creature.getIndex());
        } else if (2 == type) {
            this.updateCreature(1, creature);
            this.updateCreature(0, creature);
        }
    }

    public void updateMessages() {
        int i = 0;
        while (i < this.messages.size()) {
            String line = this.messages.get(i).toString();
            int type = (Integer)this.messages.get(i + 1);
            Color color = Color.black;
            if (type == 0) {
                color = new Color(0, 128, 0);
            } else if (1 == type) {
                color = Color.orange;
            } else if (2 == type) {
                color = Color.red;
            } else if (3 == type) {
                color = new Color(237, 164, 61);
            }
            this.networkLogs.addLogLine(line, color);
            i += 2;
        }
        this.messages.clear();
    }

    public void updateRunningState() {
        this.updateLog();
        if (this.running) {
            this.options.setStarted(true);
            this.options.setStopped(false);
            this.statusBar.addMessage("Simulation is running.", StatusBar.DEFAULT);
        } else {
            this.options.setStarted(false);
            this.options.setStopped(true);
            this.statusBar.addMessage("Simulation stopped.", StatusBar.DEFAULT);
        }
    }
}

