/*
 * Decompiled with CFR 0.152.
 */
package frams_client_3d;

import frams_client_3d.Point3D;
import frams_client_3d.Vector3D;

public class Creature {
    private String name;
    private String genotype;
    private int partsCount = 0;
    private int jointsCount = 0;
    private int[][] joints = null;
    private float[][] parts = null;
    private int group;
    private int index;

    public Creature(String name, String genotype, int partsCount, int jointsCount, int group, int index) {
        this.name = name;
        this.genotype = genotype;
        this.parts = new float[partsCount][3];
        this.joints = new int[jointsCount][2];
        this.group = group;
        this.index = index;
    }

    public void addJoint(int p1, int p2) {
        this.joints[this.jointsCount][0] = p1;
        this.joints[this.jointsCount][1] = p2;
        ++this.jointsCount;
    }

    public void addPart(float x, float y, float z) {
        this.parts[this.partsCount][0] = x;
        this.parts[this.partsCount][1] = y;
        this.parts[this.partsCount][2] = z;
        ++this.partsCount;
    }

    public String toString() {
        return this.name;
    }

    public String getGenotype() {
        return this.genotype;
    }

    public int[][] getJoints() {
        return this.joints;
    }

    public float[][] getParts() {
        return this.parts;
    }

    public int getGroup() {
        return this.group;
    }

    public int getIndex() {
        return this.index;
    }

    public float[] jointTranslation(int index) {
        Point3D p1 = new Point3D(this.parts[this.joints[index][0]]);
        Point3D p2 = new Point3D(this.parts[this.joints[index][1]]);
        Vector3D vector = p1.vector(p2);
        vector.mult(0.5f);
        p1.add(vector);
        return p1.getPoint();
    }

    public float jointLength(int index) {
        Point3D p1 = new Point3D(this.parts[this.joints[index][0]]);
        Point3D p2 = new Point3D(this.parts[this.joints[index][1]]);
        Vector3D vector = p1.vector(p2);
        return vector.length();
    }

    public float[] jointRotation(int index) {
        Point3D p1 = new Point3D(this.parts[this.joints[index][0]]);
        Point3D p2 = new Point3D(this.parts[this.joints[index][1]]);
        Vector3D vector = p1.vector(p2);
        Vector3D base = new Vector3D(1.0f, 0.0f, 0.0f);
        float cos = base.scalarProduct(vector) / vector.length();
        float angle = (float)(-Math.acos(cos) * 180.0 / Math.PI);
        vector.vectorProduct(base);
        float[] v = vector.getVector();
        float[] result = new float[]{angle, v[0], v[1], v[2]};
        return result;
    }
}

