/*
 * Decompiled with CFR 0.152.
 */
package frams_client_3d;

import frams_client_3d.CommunicationErrorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;

public class Communication {
    private Socket socket = null;
    private PrintWriter out = null;
    private BufferedReader in = null;
    private ArrayList log = new ArrayList();

    public void connect(String ip, int port) throws IOException {
        this.socket = new Socket(ip, port);
        this.out = new PrintWriter(this.socket.getOutputStream(), true);
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.sendMessage("version 2");
        String message = this.in.readLine();
        this.log.add("> " + message);
    }

    public void disconnect() throws IOException {
        this.out.close();
        this.in.close();
        this.socket.close();
    }

    public ArrayList readMessage() throws IOException, InterruptedException, CommunicationErrorException {
        String message = null;
        ArrayList<String> buffer = new ArrayList<String>();
        while (!this.in.ready()) {
            Thread.sleep(100L);
        }
        while ((message = this.in.readLine()) != null) {
            this.log.add("> " + message);
            if (message.startsWith("ok")) {
                if (3 >= message.length()) break;
                buffer.add(message);
                break;
            }
            if (message.startsWith("error")) {
                String error = message.substring(message.indexOf(32));
                throw new CommunicationErrorException(error);
            }
            buffer.add(message);
        }
        return buffer;
    }

    public void sendMessage(String message) {
        this.out.println(message);
        this.log.add(message);
    }

    public ArrayList getLog() {
        return this.log;
    }
}

