/*
 * Decompiled with CFR 0.152.
 */
package frams_client_3d;

import frams_client_3d.Point3D;
import frams_client_3d.Vector3D;

public class Camera {
    private Point3D eye = null;
    private Point3D view = null;
    private Vector3D up = null;

    public void setPosition(float[] eye, float[] view, float[] up) {
        this.eye = new Point3D(eye);
        this.view = new Point3D(view);
        this.up = new Vector3D(up);
    }

    public void zoom(float speed) {
        Vector3D vector = this.eye.vector(this.view);
        vector.normalize();
        vector.mult(speed);
        this.eye.add(vector);
    }

    public void move(float speed) {
        Vector3D vector = this.eye.vector(this.view);
        vector.normalize();
        vector.mult(speed);
        this.eye.add(vector);
        this.view.add(vector);
    }

    public void level(float speed) {
        Vector3D vector = new Vector3D(this.up);
        vector.mult(speed);
        this.eye.add(vector);
        this.view.add(vector);
    }

    public void strafe(float speed) {
        Vector3D vector = this.eye.vector(this.view);
        vector.vectorProduct(this.up);
        vector.normalize();
        vector.mult(speed);
        this.eye.add(vector);
        this.view.add(vector);
    }

    public void rotateHorizontal(float angle) {
        Vector3D vector = this.view.vector(this.eye);
        vector.rotate(angle, this.up);
        this.eye = new Point3D(this.view);
        this.eye.add(vector);
    }

    public void rotateVertical(float angle) {
        Point3D upPoint = new Point3D(this.eye);
        upPoint.add(this.up);
        Vector3D vector = this.view.vector(this.eye);
        Vector3D axis = new Vector3D(vector);
        axis.vectorProduct(this.up);
        axis.normalize();
        vector.rotate(angle, axis);
        this.eye = new Point3D(this.view);
        this.eye.add(vector);
        vector = this.view.vector(upPoint);
        vector.rotate(angle, axis);
        upPoint = new Point3D(this.view);
        upPoint.add(vector);
        this.up = this.eye.vector(upPoint);
    }

    public float[] getEye() {
        return this.eye.getPoint();
    }

    public float[] getView() {
        return this.view.getPoint();
    }

    public float[] getUp() {
        return this.up.getVector();
    }

    public Vector3D getViewVector() {
        return this.eye.vector(this.view);
    }
}

