/*
 * Decompiled with CFR 0.152.
 */
package jgl.context.render;

import jgl.context.gl_context;
import jgl.context.gl_vertex;
import jgl.context.render.gl_smooth;

public class gl_lit_tex
extends gl_smooth {
    protected float[] LineW = new float[2];
    protected float[][] LineST = new float[2][3];
    protected float w;
    protected float dwdx = 0.0f;
    protected float dwdy = 0.0f;
    protected float s;
    protected float dsdx = 0.0f;
    protected float dsdy = 0.0f;
    protected float t;
    protected float dtdx = 0.0f;
    protected float dtdy = 0.0f;
    protected float r;
    protected float drdx = 0.0f;
    protected float drdy = 0.0f;
    private float[] TriW = new float[3];
    private float[][] TriST = new float[3][3];
    protected float LeftPointW;
    protected float LeftPointS;
    protected float LeftPointT;
    protected float LeftPointR;
    private float dwdxy;
    private float dwdyy;
    private float dsdxy;
    private float dsdyy;
    private float dtdxy;
    private float dtdyy;
    private float drdxy;
    private float drdyy;

    protected void init_tex(gl_vertex gl_vertex2, gl_vertex gl_vertex3) {
        this.LineW[0] = 1.0f / gl_vertex2.Vertex[3];
        this.LineW[1] = 1.0f / gl_vertex3.Vertex[3];
        this.LineST[0][0] = gl_vertex2.TexCoord[0] * this.LineW[0];
        this.LineST[0][1] = gl_vertex2.TexCoord[1] * this.LineW[0];
        this.LineST[0][2] = gl_vertex2.TexCoord[2] * this.LineW[0];
        this.LineST[1][0] = gl_vertex3.TexCoord[0] * this.LineW[1];
        this.LineST[1][1] = gl_vertex3.TexCoord[1] * this.LineW[1];
        this.LineST[0][2] = gl_vertex3.TexCoord[2] * this.LineW[1];
    }

    protected void init(gl_vertex gl_vertex2, gl_vertex gl_vertex3) {
        super.init(gl_vertex2, gl_vertex3);
        this.init_tex(gl_vertex2, gl_vertex3);
    }

    protected void set_first_tex() {
        this.w = this.LineW[0];
        this.s = this.LineST[0][0];
        this.t = this.LineST[0][1];
        this.r = this.LineST[0][2];
    }

    protected void set_first_point() {
        super.set_first_point();
        this.set_first_tex();
    }

    protected void init_tex_dx(int n) {
        this.dwdx = (this.LineW[1] - this.LineW[0]) / (float)n;
        this.dsdx = (this.LineST[1][0] - this.LineST[0][0]) / (float)n;
        this.dtdx = (this.LineST[1][1] - this.LineST[0][1]) / (float)n;
        this.drdx = (this.LineST[1][2] - this.LineST[0][2]) / (float)n;
    }

    protected void init_tex_dy(int n) {
        this.dwdy = (this.LineW[1] - this.LineW[0]) / (float)n;
        this.dsdy = (this.LineST[1][0] - this.LineST[0][0]) / (float)n;
        this.dtdy = (this.LineST[1][1] - this.LineST[0][1]) / (float)n;
        this.drdy = (this.LineST[1][2] - this.LineST[0][2]) / (float)n;
    }

    protected void init_dx(int n) {
        this.init_tex_dx(n);
    }

    protected void init_dy(int n) {
        this.init_tex_dy(n);
    }

    protected void init_dx_dy(int n, int n2) {
        super.init_dx_dy(n, n2);
        if (n != 0) {
            this.init_dx(n);
        }
        this.init_dy(n2);
    }

    protected void tex_inc_x() {
        this.w += this.dwdx;
        this.s += this.dsdx;
        this.t += this.dtdx;
        this.r += this.drdx;
    }

    protected void tex_dec_x() {
        this.w -= this.dwdx;
        this.s -= this.dsdx;
        this.t -= this.dtdx;
        this.r -= this.drdx;
    }

    protected void tex_inc_y() {
        this.w += this.dwdy;
        this.s += this.dsdy;
        this.t += this.dtdy;
        this.r += this.drdx;
    }

    protected void inc_x() {
        super.inc_x();
        this.tex_inc_x();
    }

    protected void dec_x() {
        super.dec_x();
        this.tex_dec_x();
    }

    protected void inc_y() {
        super.inc_y();
        this.tex_inc_y();
    }

    protected void inc_x_inc_y() {
        super.inc_x_inc_y();
        this.tex_inc_x();
    }

    protected void dec_x_inc_y() {
        super.dec_x_inc_y();
        this.tex_dec_x();
    }

    protected void put_pixel() {
        this.pixel.put_pixel(this.x, this.y, this.w, this.s / this.w, this.t / this.w, this.r / this.w, this.dsdx, this.dsdy, this.dtdx, this.dtdy, this.drdx, this.drdy, this.rgb);
    }

    protected void put_pixel_by_index() {
        this.pixel.put_pixel_by_index(this.x, this.w, this.s / this.w, this.t / this.w, this.r / this.w, this.dsdx, this.dsdy, this.dtdx, this.dtdy, this.drdx, this.drdy, this.rgb);
    }

    protected void draw_horizontal_line(int n, int[] nArray, int n2, int[] nArray2, int n3, float f, float f2, float f3, float f4) {
        this.LineW[0] = f;
        this.LineST[0][0] = f2;
        this.LineST[0][1] = f3;
        this.LineST[0][2] = f4;
        this.draw_horizontal_line(n, nArray, n2, nArray2, n3);
    }

    protected void init_tex(gl_vertex gl_vertex2, gl_vertex gl_vertex3, gl_vertex gl_vertex4) {
        this.TriW[0] = 1.0f / gl_vertex2.Vertex[3];
        this.TriW[1] = 1.0f / gl_vertex3.Vertex[3];
        this.TriW[2] = 1.0f / gl_vertex4.Vertex[3];
        this.TriST[0][0] = gl_vertex2.TexCoord[0] * this.TriW[0];
        this.TriST[0][1] = gl_vertex2.TexCoord[1] * this.TriW[0];
        this.TriST[0][2] = gl_vertex2.TexCoord[2] * this.TriW[0];
        this.TriST[1][0] = gl_vertex3.TexCoord[0] * this.TriW[1];
        this.TriST[1][1] = gl_vertex3.TexCoord[1] * this.TriW[1];
        this.TriST[1][2] = gl_vertex3.TexCoord[2] * this.TriW[1];
        this.TriST[2][0] = gl_vertex4.TexCoord[0] * this.TriW[2];
        this.TriST[2][1] = gl_vertex4.TexCoord[1] * this.TriW[2];
        this.TriST[2][2] = gl_vertex4.TexCoord[2] * this.TriW[2];
    }

    protected void init(gl_vertex gl_vertex2, gl_vertex gl_vertex3, gl_vertex gl_vertex4) {
        super.init(gl_vertex2, gl_vertex3, gl_vertex4);
        this.init_tex(gl_vertex2, gl_vertex3, gl_vertex4);
    }

    protected void set_left_tex(int n) {
        this.LeftPointW = this.TriW[n];
        this.LeftPointS = this.TriST[n][0];
        this.LeftPointT = this.TriST[n][1];
        this.LeftPointR = this.TriST[n][2];
    }

    protected void set_left(int n) {
        super.set_left(n);
        this.set_left_tex(n);
    }

    protected void init_tex_dx_dy(int n, int n2, int n3, int n4) {
        float f = this.TriW[n2] - this.TriW[n4];
        float f2 = this.TriW[n3] - this.TriW[n4];
        this.dwdx = (f2 * (float)this.dyl - f * (float)this.dyr) / (float)n;
        this.dwdy = (f * (float)this.dxr - f2 * (float)this.dxl) / (float)n;
        f = this.TriST[n2][0] - this.TriST[n4][0];
        f2 = this.TriST[n3][0] - this.TriST[n4][0];
        this.dsdx = (f2 * (float)this.dyl - f * (float)this.dyr) / (float)n;
        this.dsdy = (f * (float)this.dxr - f2 * (float)this.dxl) / (float)n;
        f = this.TriST[n2][1] - this.TriST[n4][1];
        f2 = this.TriST[n3][1] - this.TriST[n4][1];
        this.dtdx = (f2 * (float)this.dyl - f * (float)this.dyr) / (float)n;
        this.dtdy = (f * (float)this.dxr - f2 * (float)this.dxl) / (float)n;
        f = this.TriST[n2][2] - this.TriST[n4][2];
        f2 = this.TriST[n3][2] - this.TriST[n4][2];
        this.drdx = (f2 * (float)this.dyl - f * (float)this.dyr) / (float)n;
        this.drdy = (f * (float)this.dxr - f2 * (float)this.dxl) / (float)n;
    }

    protected void init_dx_dy(int n, int n2, int n3, int n4) {
        this.init_tex_dx_dy(n, n2, n3, n4);
    }

    protected void init_tex_other(boolean bl, int n) {
        this.dwdxy = this.dwdx * (float)n + this.dwdy;
        this.dwdyy = bl ? this.dwdxy - this.dwdx : this.dwdxy + this.dwdx;
        this.dsdxy = this.dsdx * (float)n + this.dsdy;
        this.dsdyy = bl ? this.dsdxy - this.dsdx : this.dsdxy + this.dsdx;
        this.dtdxy = this.dtdx * (float)n + this.dtdy;
        this.dtdyy = bl ? this.dtdxy - this.dtdx : this.dtdxy + this.dtdx;
        this.drdxy = this.drdx * (float)n + this.drdy;
        this.drdyy = bl ? this.drdxy - this.drdx : this.drdxy + this.drdx;
    }

    protected void init_other(boolean bl, int n) {
        this.init_tex_other(bl, n);
    }

    protected void tex_inc_y_once() {
        this.LeftPointW += this.dwdxy;
        this.LeftPointS += this.dsdxy;
        this.LeftPointT += this.dtdxy;
        this.LeftPointR += this.drdxy;
    }

    protected void inc_y_once() {
        this.tex_inc_y_once();
    }

    protected void tex_inc_y_more() {
        this.LeftPointW += this.dwdyy;
        this.LeftPointS += this.dsdyy;
        this.LeftPointT += this.dtdyy;
        this.LeftPointR += this.drdyy;
    }

    protected void inc_y_more() {
        this.tex_inc_y_more();
    }

    protected void draw_horizontal_line(int n) {
        this.draw_horizontal_line(this.LeftPoint, this.LeftPointRGB, this.RightPoint, this.RightPointRGB, n, this.LeftPointW, this.LeftPointS, this.LeftPointT, this.LeftPointR);
    }

    public gl_lit_tex(gl_context gl_context2) {
        super(gl_context2);
    }
}

