//size versus energy
//real proportions

// -------------------------------- step begin --------------------------------

function reproduce_haploid(repro_list)
{
	var len = repro_list.size;
	if (len % 2 != 0) len = repro_list.size - 1;

	for (var i = 0; i < len - 2 ; i = i + 2)
	{
		var parent = Populations[0].get(repro_list[i]);
		var parent2 = Populations[0].get(repro_list[i + 1]);

		var number = parent.user2["Va"] / ExpParams.ofnumd + parent2.user2["Va"] / ExpParams.ofnumd;

		for (var j = 0; j < number; j++)
		{
			createOffspring(ExpParams.gend, ExpParams.ofnumd, [parent.user1, parent2.user1], {"Va" : ExpParams.ofnumd, "gen" : 1 , "growth_step" : ExpParams.growth_step, "rsize": ExpParams.rads[1], "vinit": ExpParams.ofnumd}); //TODO genes from both generations in user1
		}
	}
	killParents(repro_list);
}

function reproduce_diploid(repro_list)
{
	for (var i = 0; i < repro_list.size; i++)
	{
		var parent = Populations[0].get(repro_list[i]);

		if (parent.user2["gen"] != 1)
		{
			Simulator.print("gen: " + parent.user2["gen"]);
		}

		if (parent.user2["gen"] == 1)
		{
			var number = parent.user2["Va"] / ExpParams.ofnumh;
			for (var j = 0; j < number / 2; j++)
			{
				var crossed = 0;
				//crossover
				if (Math.rnd01 < ExpParams.crossprob)
				{
					crossover(parent, "vamin");
					crossed = 1;
				}

				for (var k = 0; k < 2; k++)
				{
					createOffspring(ExpParams.genh, ExpParams.ofnumh, {"vamin" : ExpParams.v_min_h, "amin": ExpParams.age_min_h}, {"Va" : ExpParams.ofnumh, "gen" : 0 , "growth_step" : ExpParams.growth_step, "rsize" : ExpParams.rads[0], "vinit": ExpParams.ofnumh});
				}

				//reverse of crossover for fossilization
				if (crossed == 1)
				{
					crossover(parent, "vamin");
					crossed = 0;
				}
			}
		}
	}
	killParents(repro_list);
}

function crossover(parent, gene)
{
	var tmp = parent.user1[0][gene];
	parent.user1[0][gene] = parent.user1[1][gene];
	parent.user1[1][gene] = tmp;
}

function killParents(repro_list)
{
	for (var j = 0; j < repro_list.size; j++)
	{
		Populations[0].kill(repro_list[j]);
	}
}

function createOffspring(geno, energy, new_user1, new_user2)
{
	var cr = Populations[0].add(geno);
	cr.energy0 = energy;
	cr.energy = cr.energy0;
	setGenotype(cr, new_user1, new_user2);
	placeRandomlyNotColliding(cr);
}

function onStep()
{
	var haploids = 0;
	var diploids = 0;
	var e_inc_h = 0.0;
	var e_inc_d = 0.0;
	var e_nut = 0.0;
	var size_h = 0.0;
	var size_d = 0.0;
	var vmin_h = 0.0;
	var vmin_d = 0.0;

	for (var i = 0; i < Populations[0].size; i++)
	{
		var cr = Populations[0].get(i);
		if (cr.user2["gen"] == 0)
		{
			haploids += 1;
			e_inc_h += cr.energy;
			size_h += ExpParams.rads[0]; //TODO change of size dependent on gene
			vmin_h += cr.user1["vamin"];
		}
		else if (cr.user2["gen"] == 1)
		{
			diploids += 1;
			e_inc_d += cr.energy;
			size_d += ExpParams.rads[1]; //TODO change of size dependent on gene
			vmin_d += cr.user1[0]["vamin"];
		}
	}

	for (var i = 0; i < Populations[1].size; i++)
	{
		var cr = Populations[1].get(i);
		e_nut += cr.energy;
	}

	if (haploids < 2 && diploids == 0)
	{
		Simulator.print("no more creatures, stopped.");
		Simulator.stop();
	}

	var l1 = [haploids, diploids, Populations[1].size];
	var l2 = [e_inc_h, e_inc_d, e_nut];
	var dp = diploids;
	var hp = haploids;
	if (dp == 0) dp = 0.000001;
	if (hp == 0) hp = 0.000001;
	var l3 = [size_h / hp, vmin_h / hp, size_d / dp, vmin_d / dp];

	if (ExpParams.logging == 1)
	{
		log(l1, "log.txt");
		log(l2, "log2.txt");
		log(l3, "log3.txt");
	}
	//food growth ---------------------------------------------
	foodenergywaiting = foodenergywaiting + ExpParams.feedrate;
	if (foodenergywaiting > ExpParams.feede0)
	{
		for (var i = 0; i < ExpParams.foodPop; i++)
		{
			addfood();
		}

		foodenergywaiting = 0.0;
		Simulator.checkpoint();
	}

	//reproduction --------------------------------------------
	reprocounter += 1;
	if (reprocounter > ExpParams.repro_time)
	{
		reprocounter = 0;
		var to_repro_h = [];
		var to_repro_d = [];
		for (var i = 0; i < Populations[0].size; i++)
		{
			var cr = Populations[0].get(i);
			if (cr.signals.size > 0)
			{
				if (cr.user2["gen"] == 0)
				{
					to_repro_h.add(i);
				}
				if (cr.user2["gen"] == 1)
				{
					to_repro_d.add(i);
				}
			}
		}
		if (to_repro_h.size > 1)
		{
			reproduce_haploid(to_repro_h);
		}
		if (to_repro_d.size > 0)
		{
			reproduce_diploid(to_repro_d);
		}
	}

	//check for death -----------------------------------------------
	if (Populations[0].size == 0)
	{
		if (ExpParams.autorestart)
		{
			Simulator.print("no more creatures, restarting...");
			onExpInit();
		}
		else
		{
			Simulator.print("no more creatures, stopped.");
			Simulator.stop();
		}
	}
}

// -------------------------------- step end --------------------------------
