//
// framsticks.inc, standard (default) setup
//
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "foram.inc"

#debug concat("Animation Frame #",str(AnimFrame,5,0))

////////////////////////////////
// you can override these settings in your "framsticks-user.inc" file:

#ifndef (LightAz)
 #declare LightAz=60;
#end
#ifndef (LightAlt)
 #declare LightAlt=50;
#end
#ifndef (LightColor)
 #declare LightColor=rgb<1,1,1>;
#end
#ifndef (LightDistance)
 #declare LightDistance=4000;
#end
#ifndef (LightSize) // >0 means area_light
 #declare LightSize=250;
#end
#ifndef (HeightfieldMode)
 #declare HeightfieldMode=2;//0=Triangles,1=Smooth triangles,2=Bicubic patch
#end
// #declare Override_OFFSET_Z=...;

#ifndef (WaterFogColor)
 #declare WaterFogColor = rgbf<0.1, 0.4, 0.6, 0.3>;
#end
#ifndef (WaterFogDistance)
 #declare WaterFogDistance = 20;
#end
#ifndef (UnderwaterSurfaceGlow)
 #declare UnderwaterSurfaceGlow = rgbf <0.9,1,1,0.9>;
#end

#declare HorizonColor_2=<0.9, 0.92, 0.95>;
#declare MidSkyColor0_2=<0.93,0.93,0.93>;
#declare MidSkyColor1_2=<0.88,0.88,0.88>;
#declare MidSkyColor2_2=<0.4, 0.4, 0.8>;
#declare MidSkyColor3_2=<0.31, 0.36, 0.93>;
#declare HighSkyColor0_2=<0.95,0.95,0.95>;
#declare HighSkyColor1_2=<0.9,0.9,0.9>;
#declare HighSkyColor2_2=<0.4, 0.4, 0.8>;
#declare HighSkyColor3_2=<0.04, 0.2, 0.66>;
#declare LightColor_2=<1,1,1>;

#declare HorizonColor_1=<0.9, 0.8, 0.6>;
#declare MidSkyColor0_1=<0.93,0.93,0.43>;
#declare MidSkyColor1_1=<0.88,0.78,0.48>;
#declare MidSkyColor2_1=<0.8, 0.5, 0.5>;
#declare MidSkyColor3_1=<0.4, 0.2, 0.5>;
#declare HighSkyColor0_1=<0.9,0.9,0.9>;
#declare HighSkyColor1_1=<0.9,0.5,0.8>;
#declare HighSkyColor2_1=<0.6, 0.3, 0.6>;
#declare HighSkyColor3_1=<0.3, 0.2, 0.5>;
#declare LightColor_1=<1,0.7,0.3>;

#declare HorizonColor_0=<0.9, 0.4, 0.2>;
#declare MidSkyColor0_0=<0.9,0.1,0.7>;
#declare MidSkyColor1_0=<0.7,0.5,0.4>;
#declare MidSkyColor2_0=<0.3,0.2,0.6>;
#declare MidSkyColor3_0=<0.3,0.05,0.3>;
#declare HighSkyColor0_0=<0.3,0.3,0.7>;
#declare HighSkyColor1_0=<0.1,0.1,0.5>;
#declare HighSkyColor2_0=<0.05, 0.05, 0.3>;
#declare HighSkyColor3_0=<0.05, 0.05, 0.2>;
#declare LightColor_0=<1,0.3,0.2>;

#declare SimpleGround=0;
// Camera(<position>,<look_at_target>)

////////////////////////////////

#declare CameraLocation=<0,0,1>;

#declare StandardCamera=camera { up <0,0,1> right <image_width/image_height,0,0> sky <0,0,1> location <0,0,0> look_at <0,1,0> }
//pov doc: direction_length = 0.5 * right_length / tan(angle / 2)
//         horiz.angle=2*atan( w/h / 2)                    = 83.3 (16:9)     67.4 (4:3)
//         diag.angle=2*atan( sqrt(w^2+h^2)/h /2)          = 91.1 (16:9)     79.6 (4:3)

#declare GlobalAmbient=5; //oryg. 3

global_settings
 {
 max_trace_level 100
 adc_bailout 0.1
 ambient_light GlobalAmbient
 assumed_gamma 2.2
 }

#declare field_World_simtype=0;
#declare field_ODE_odeshape=0;

//////////////////////////////////////////
// colours
///////////////////////////////////////////
// stick:
#declare OldStickRGB = <0.65,0.65,0.55>;
#declare OldStick2RGB = <0.55,0.55,0.45>;
#declare StickRGB = <0.46,0.57,0.42>;
#declare StaminaRGB = <0.53,0.65,0.50>;
#declare IngestRGB = <0.93,0.93,0>;
#declare AsimilRGB = <0.14,1,0.14>;

/////////////////////
// muscle
#declare Muscle1RGB=<1,0.1,0.1>;
#declare Muscle2RGB=<1,0,0>;
#declare Muscle3RGB=<0.3,0,0>;

//{  distance 60   colour rgb<0.6, 0.8, 0.75> } //dist 16 ok

///////////////////////////////

#declare SimpleStickTexture = texture
	{ pigment { color Red }
	  finish { phong 1 }
   }

///////////////////////////////
// world:

#declare WORLD_FLAT=0;
#declare WORLD_BLOCKS=1;
#declare WORLD_SMOOTH=2;

#declare BORDER_NONE=0;
#declare BORDER_FENCE=1;
#declare BORDER_TELEPORT=2;

#declare WallTexture = texture { pigment {granite} }

#declare Ground0Texture = texture
	{ pigment
#if (SimpleGround)
   {color rgb <1,1,1>}      //white
#else
//   {color rgb <1,0.9,0.6>}
	 {
	 granite
		color_map
			{
			[ 0.0 rgb <0.95, 0.90, 0.60> ]
			[ 0.7 rgb <0.76, 0.70, 0.40> ]
			[ 1.0 rgb <0.76, 0.70, 0.40> ]
			}
	 scale .5 					//3
	 }
    normal {bumps 0.2 scale 0.02}
#end
	}

/////////////////////////////////

#declare UnderwaterTexture=texture
{
	pigment
    {
	 granite
	color_map
      { [ 0 color Gray60 ]
		  [ 1 color White ] }
	scale 2
    }
  finish {ambient 0.7/GlobalAmbient diffuse 0.3 }
}

/////////////////////////////////

#declare HighTexture=texture
{
	pigment
    {
	 crackle
	color_map
      { [ 0 color Gray40 ]
		  [ 0.1 color Gray80 ]
		  [ 1 color White ] }
    }
}


///////////////////////////////////

/*
#declare HighTexture=texture
	{
	pigment
//   {color rgb <1,0.9,0.6>}
	 {
	 granite
		color_map
			{
			[ 0.0 rgb <0.95, 0.90, 0.60> ]
			[ 0.7 rgb <0.76, 0.70, 0.40> ]
			[ 1.0 rgb <0.76, 0.70, 0.40> ]
			}
	 scale .5  					//3
	 }
    normal {bumps 0.2 scale 0.02}
	}
*/

/////////////////////////////////////////

#macro WaterTexture()
texture
{
#if (CameraIsUnderwater())
 pigment { bumps scale 2
 pigment_map {
            [0 rgbf <0.5,0.5,0.5,0.5>+UnderwaterSurfaceGlow*0.5 ]
            [0.5 rgbf UnderwaterSurfaceGlow ]
            [1 rgbf <0.5,0.5,0.5,0.5>+UnderwaterSurfaceGlow*0.5 ]
	    }
 }
#else
 pigment { rgbf<0.3, 0.7, 0.9, 0.9> }
#end
 finish { reflection { 0.5 fresnel on } conserve_energy
#if (CameraIsUnderwater())
   ambient 1
#else
   ambient 0
#end
    }
 normal { bumps 0.5 scale 2 }
 translate WaterWaveSpeed*AnimFrame
}
#end

#declare WaterInterior = interior
{ ior 1.3 caustics 0.3 }

#declare WaterWaveSpeed = <0,0,0.2>;

///////////////////////////////////////////////
// LIGHT SOURCE

#macro StandardLight()
light_source
 {
  <0,-LightDistance,0>
  color LightColor
#if (LightSize>0)
  area_light  <LightSize,0,0> <0,0,LightSize>  4, 4
  adaptive 1    jitter
#end
  rotate -x*LightAlt
  rotate z*LightAz
 }
#end

//////////////////////////////////////////////////////////
// SKY

#macro StandardSky()
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb HorizonColor ] // horizon
            [0.25
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0 color rgb MidSkyColor0]
        [0.1 color rgb MidSkyColor1]
        [0.5 color rgb MidSkyColor2]
        [1.001 color rgb MidSkyColor3]
    }
    scale <1.5, 0.25, 1.5> rotate z*5]
  [0.60
    bozo
    color_map {
        [0.0 color rgb HighSkyColor0]
        [0.1 color rgb HighSkyColor1]
        [0.5 color rgb HighSkyColor2]
        [1.001 color rgb HighSkyColor3]
    }
    turbulence 0.65
    octaves 6
    omega 0.707
    lambda 2
    scale <1.5, 0.6, 1.5> rotate z*10]
        }
    }
 rotate <90,0,0>
}
#end

//background { color SkyBlue }

///////////////////////////////////////////////
// MANIPULATOR

#declare ManipulatorArm = union
 {
 cylinder { <0,0,0>,<0,0,10>,0.2 }
 sphere { <0,0,0>,0.3 }
 }
#declare ManipulatorFinger = union
 {
 cylinder { <0,0,0>,<-1,0,-1>,0.17 }
 sphere { <-1,0,-1>,0.17 }
 cone { <-1,0,-1>,0.17,<0,0,-2>,0.1 }
 sphere { <0,0,-2>,0.1 }
 }
#declare ManipulatorTexture=Aluminum

#macro Manipulator(Location,State)
union
 {
 object {ManipulatorArm}
 object {ManipulatorFinger rotate <0,5+25*abs(State),0>}
 object {ManipulatorFinger rotate <0,5+25*abs(State),180>}
 translate <0,0,2>
 texture {ManipulatorTexture}
 scale 0.5
 rotate <0,0,180>*abs(State)
 translate Location+<0,0,10>*abs(State)
 }
#end

///////////////////////////////////////////////
// FENCE

#declare FenceSegmentLen = 5;
#declare FenceHeight = 4;
#declare FenceBeamSpacing = 1;
#declare FenceBeamHeight = 1;
#declare FenceBeamsNum = 3;

#declare FenceTexture = texture { T_Wood17 scale 0.6 }

// FENCE

#declare FenceBeam = object
{
cylinder { <-0.4-FenceSegmentLen/2,0,0>,<FenceSegmentLen/2+0.4,0,0>,0.15
 texture {FenceTexture rotate <0,90,0> }}
}
#declare FencePost = union
{
box { <-0.2,-0.2,0>,<0.2,0.2,FenceHeight> }
  union
  {
  triangle { <-0.2,-0.2,0>,<-0.2,0.2,0>,<0,0,0.2> }
  triangle { <-0.2, 0.2,0>,< 0.2,0.2,0>,<0,0,0.2> }
  triangle { < 0.2, 0.2,0>,< 0.2,-0.2,0>,<0,0,0.2> }
  triangle { < 0.2,-0.2,0>,<-0.2,-0.2,0>,<0,0,0.2> }
   translate FenceHeight*z
  }
texture { FenceTexture }
}

#declare FenceSegment = union
{
object { FencePost }
#local N=FenceBeamsNum;
#local Y=FenceHeight;
#local R=seed(3333);
#while (N>0)
 #local Y=Y-FenceBeamSpacing;
 #local N=N-1;
 object { FenceBeam rotate <360*rand(R),(rand(R)-0.5)*20*atan2(FenceBeamSpacing,FenceSegmentLen),0> translate <FenceSegmentLen/2,0,Y> }
#end
}

#macro Fence()
#local K=field_World_wrldsiz;
#while (K>7) #local K=K/2; #end
#local K=K+0.0001;
#local X=0;
#while (X<field_World_wrldsiz-0.001)
object {FenceSegment scale <K/FenceSegmentLen,1,1>
	 translate <X,0,OFFSET_Z> }
object {FenceSegment scale <K/FenceSegmentLen,1,1>
    rotate <0,0,90>
	 translate <field_World_wrldsiz,X,OFFSET_Z> }
object {FenceSegment scale <K/FenceSegmentLen,1,1>
    rotate <0,0,180>
	 translate <field_World_wrldsiz-X,field_World_wrldsiz,OFFSET_Z> }
object {FenceSegment scale <K/FenceSegmentLen,1,1>
    rotate <0,0,270>
	 translate <0,field_World_wrldsiz-X,OFFSET_Z> }
#local X=X+K;
#end
#end

#macro TeleportBoundary()
difference 
 {box {<-5,-5,0.001>,<field_World_wrldsiz+5,field_World_wrldsiz+5,1>}
  box {<0,0,0>,<field_World_wrldsiz,field_World_wrldsiz,1.001>}

 pigment {color rgbf <1,1,1,1>}
 interior {media
	{ emission 0.1
	  density {gradient z translate <0,0,2> }
	}
   }
 hollow
 scale <1,1,7>
 translate <0,0,OFFSET_Z>
 }
#end

/////////////////////////////////////
// ENERGY

#declare EnergyTexture = texture
{
pigment { marble
  color_map {
   [ 0 color rgbf <1,1,1,0.9> ]
   [ 0.1 color rgbf <1,0.95,0.85,0.9> ]
   [ 0.2 color rgbf <1,0.95,0.8,0.95> ]
   [ 0.6 color rgbf <1,0.9,0.8,0.95>]
            }
		turbulence 0.5
        }
	finish { ambient 1.0/GlobalAmbient
	         phong 0.4 }
}

#macro BeginEnergy()
#end

#macro EndEnergy()
#if (NumEnergyComponents>0)
blob {
 threshold 1
 #while (NumEnergyComponents>0)
  #declare NumEnergyComponents=NumEnergyComponents-1;
  component EnergyComponentsPower[NumEnergyComponents] EnergyComponentsPower[NumEnergyComponents] EnergyComponents[NumEnergyComponents] 
 #end
 texture {EnergyTexture translate <AnimFrame*0.03,0,0>}
 hollow
 }
#end
#end

#declare REnergySeed=seed(300+mod(AnimFrame,20));

#declare PureEnergy=
union
{
 sphere
  { 0, 1 pigment { bozo color_map {[0.0 color rgbt <1,1,1,0.95>][1.0 color rgbt <1,1,1,1>]}
                 scale 0.2+0.2*rand(REnergySeed) turbulence 2 }
          finish { ambient rgb 5*<2,1,0.5>/GlobalAmbient } hollow
  } 
#local N=10;
#while (N>0)
 sphere { 0, 0.7 pigment {color rgbt <1,1,1,0.85>}
         finish { ambient rgb 5*<1,1,0.5>/GlobalAmbient } hollow scale <1,0.1,0.1>
 rotate <360.0*rand(REnergySeed),360.0*rand(REnergySeed),360.0*rand(REnergySeed)>
  }
#local N=N-1;
#end
}

/*
#declare PureEnergy=
sphere { 0, 1
  pigment { rgbt<1, 1, 1, 1> }
  interior {
    media {
      emission <5,5,2>
      density {
        spherical
        turbulence 0.5
//        color_map {
//          [0.0 color rgb <0, 0, 0>]
//          [0.4 color rgb <1, 0, 0>]
//          [0.7 color rgb <1, 1, 0.5>]
//          [1.0 color rgb <1, 1, 1>]
//        } 
      }
    }
  }
  hollow
}
*/


#declare MAXNRGCOMP=50;
#declare EnergyComponents=array[MAXNRGCOMP]
#declare EnergyComponentsPower=array[MAXNRGCOMP]
#declare NumEnergyComponents=0;

#macro AddEnergyComponent(Location,Power)
#if (NumEnergyComponents<MAXNRGCOMP)
#declare EnergyComponents[NumEnergyComponents]=Location;
#declare EnergyComponentsPower[NumEnergyComponents]=Power;
#declare NumEnergyComponents=NumEnergyComponents+1;
#end
#end

#macro Energy(Location,Amount)
#if (Amount>1)
#local R=1;
#else
#local R=Amount;
#end
#if (R>0.0001)
AddEnergyComponent(Location,2)
light_source { 0 color <1,0.5,0.2> shadowless 
	fade_distance 1 fade_power 2 looks_like
{
//union {
// sphere {0,R
//	texture {EnergyTexture translate <AnimFrame*0.03,0,0>}
//    hollow
//        }
 object { PureEnergy scale 0.5 }
// }
}
translate Location + <0,0,0.1>
}
#end
#end

/////////////////////////////////////

#declare StickEndR=0.15;

#macro CreatureStickEnd(Location,Rotation)
union {
#if (field_World_simtype & field_ODE_odeshape)
 box { <-0.2,-0.2,-0.2>,<0.2,0.2,0.2>
#else
sphere { <0,0,0>,StickEndR
#end
 texture
   {
   pigment { color StickRGB }
   normal { bumps 1.5*field_p_fr scale 0.01 }
   finish { phong (1-field_p_fr) }
   }
       }
#if (St_Recept_S)
difference {
 cylinder { <-0.15,0,0>,<-0.25,0,0>,0.12 pigment { color rgb <1,0.6,0> }}
#local N=10;
#while (N>0)
 #local N=N-1;
 sphere { <-0.18,0.12,0>,0.019 pigment { color Gray10 } rotate x*N*36 }
 sphere { <-0.22,0.12,0>,0.019 pigment { color Gray10 } rotate x*(18+N*36) }
#end
 }
#end // Recept_S

#if (St_Recept_T)
 #local N=3;
 #while (N>0)
  #local N=N-1;
  union {
    cylinder { <0,0.1,0>,<0.15,0.12,0>,0.01 }
    sphere { <0.15,0.12,0>,0.01 }
    cone { <0.15,0.12,0>,0.01,<0.3,0.15,0>,0.007 }
    sphere { <0.3,0.15,0>,0.02 }
    texture { pigment { color rgb <0.1,0.1,0.1> } 
      finish { phong 1 } }
    rotate <45+120*N,0,0>
    }
 #end
#end // St_Recept_T

#if (field_p_ing > 0.05)
 #local N=field_p_ing*50;
 #local R=seed(123);
 #while (N>0)
  #local N=N-1;
  sphere { <0,0,StickEndR-0.01> 0.03
  texture { 
	pigment { color rgb IngestRGB }
	finish { phong 1 }
	}
   rotate <0,360*rand(R),360*rand(R)>
    }
 #end
#end
rotate Rotation*57.3
translate Location
}
#end

/////////////////////////////////////////////////////////////

#declare MuscleTexture = texture
{
pigment
 {
 gradient x   frequency 1   turbulence 0.1   ramp_wave
 color_map {[0 color Muscle1RGB]  [0.2 color Muscle2RGB]  [1 color Muscle3RGB]}
 }
normal { radial   scallop_wave   frequency 6   rotate <0,0,90> }
finish { phong 0.6 }
}

#declare Muscle = union
{
cylinder {<0,0,0>,<1,0,0>,0.1}
sphere {<0,0,0>,0.1}
texture {MuscleTexture}
}

#macro ShapeTexture()
   texture {
     pigment {
             ripples scale 0.2 turbulence 1.5
             color_map {
	               [0.0 color rgb <field_p_vr, field_p_vg, field_p_vb>*0.8]
	               [1.0 color rgb <field_p_vr, field_p_vg, field_p_vb>*1.1]
		       }
              scale <1.0/field_p_sx,1.0/field_p_sy,1.0/field_p_sz>
              }
     finish { phong 1 }
     }
#end
  
#macro ForamShape(Location,Rotation)
  object { ForamSphereMesh(2.0/(field_p_sx+field_p_sy+field_p_sz))
  scale <field_p_sx,field_p_sy,field_p_sz>
  rotate Rotation*57.3
  translate Location
  }
#end

#macro CylinderShape(Location,Rotation)
cylinder
  {
  <-1,0,0>,<1,0,0>,1
  ShapeTexture()
  scale <field_p_sx,field_p_sy,field_p_sz>
  rotate Rotation*57.3
  translate Location
  }
#end

#macro CuboidShape(Location,Rotation)
box
  {
  <-1,-1,-1>,<1,1,1>
  ShapeTexture()
  scale <field_p_sx,field_p_sy,field_p_sz>
  rotate Rotation*57.3
  translate Location
  }
#end

#macro EllipsoidShape(Location,Rotation)
sphere
  {
  <0,0,0>,1
  ShapeTexture()
  scale <field_p_sx,field_p_sy,field_p_sz>
  rotate Rotation*57.3
  translate Location
  }
#end

#macro CreatureStick(Location1,Location2,Rotation)
#local Chlorofil = pigment
  {
  gradient x
  frequency 2
  turbulence 2
  color_map {[0 color StickRGB]  [0.95-St_Asimil color StickRGB]  [1.05-St_Asimil color AsimilRGB]}
  triangle_wave
  }
#local StickTexture=texture
{
pigment {Chlorofil}
finish { phong 1 }
}

union
{
#if (St_Recept_G)
union { difference {
#end
#if (field_World_simtype & field_ODE_odeshape)
 box { <0,-0.1,-0.1>,<1,0.1,0.1> texture {StickTexture} }
#else
 cylinder { <0,0,0>,<1,0,0>,0.1 texture {StickTexture} }
#end
#if (St_Recept_G)
  cylinder { <0.38,0,0>,<0.62,0,0>,0.11 }
  }
 cylinder { <0.38,0,0>,<0.62,0,0>,0.11
  texture
    {
    pigment  {color rgbf <1.0, 1.0, 1.0, 0.9>}
    finish   {ambient 0   diffuse 0   reflection 0.5  phong 0.3   phong_size 60}
    }
   interior {ior 1.4}
          }
 sphere { <0.5,0,0>,0.03
          texture { pigment { color rgb <1,0,0> } finish { phong 1 } }
        }
 }
#end // Recept_G

#if (St_BendMuscle)
 #local R=0.2;
 #local NumSeg=12;
 #local Angle=0;
 #local Vect=<R,0,0>;
 #local O=(pi+St_BendMusclePos)*R;
 #local Len1=O/NumSeg;
 #local Angle2=0;
 #local Vect2=<R,0,0>;
 #local O2=(pi-St_BendMusclePos)*R;
 #local Len12=O2/NumSeg;
 #local A=1;

 #while (A<NumSeg)
  #local A=A+1;
  #local Angle=Angle+(pi+St_BendMusclePos)/NumSeg;
  #local Angle2=Angle2+(pi-St_BendMusclePos)/NumSeg;

#if (St_BendMusclePos>-2.8)
  object
    { Muscle
    scale <Len1,St_Speed,St_Speed>
    rotate <0,0,270-degrees(Angle)>
    translate Vect
    }
#end
#if (St_BendMusclePos<2.8)
  object
    { Muscle
    scale <Len12,St_Speed,St_Speed>
    rotate <0,0,90+degrees(Angle2)>
    translate Vect2
    }
#end

  #local Vect=Vect+<-sin(Angle),-cos(Angle),0>*Len1;
  #local Vect2=Vect2+<-sin(Angle2),cos(Angle2),0>*Len12;
 #end
#end // BendMuscle

#if (St_RotMuscle)
 torus { 0.12, 0.1*St_Speed
texture
{
  pigment
   {
   radial
   frequency 25
   turbulence 0.1
   ramp_wave
    color_map { [ 0 color Muscle1RGB ]  [ 0.2 color Muscle2RGB ]  [ 1 color Muscle3RGB ] }
   }

   finish { phong 0.6 }
   } 
   rotate <0,0,90>
   translate <0.13,0,0>
  }
#end

#if (field_j_stam>0.05)
 #local N=6;
 #while (N>0)
  #local N=N-1;
  cylinder 
   { <0,0,0.1>,<1,0,0.1>,field_j_stam*0.04
   rotate <N*60,0,0>
   texture { pigment { color rgb StaminaRGB } }
   }
 #end
#end
scale <vlength(Location2-Location1),1,1>
rotate Rotation*57.3
translate Location1
}
#end


////////////////////////////////////////////////

#macro GetGroundTexture(Height)
#if (Height>field_World_wrldwat)
#if (Height>(field_World_wrldwat+2))
texture {HighTexture}
#else
texture {Ground0Texture}
#end
#else
texture {UnderwaterTexture}
#end
#end

#macro CommonWorldObjects()
#end

#declare field_World_wrldtyp=0;
#declare field_World_wrldwat=0;
#declare field_World_wrldbnd=0;

#macro BeginWorld()
#ifdef (Override_OFFSET_Z)
 #declare OFFSET_Z=Override_OFFSET_Z;
#else
 #if (field_World_simtype=1)
  #declare OFFSET_Z=0.0;
 #else
  #declare OFFSET_Z=-0.15;
 #end
#end
CommonWorldObjects()
#switch (field_World_wrldtyp)
#case (WORLD_FLAT)
plane { z,OFFSET_Z GetGroundTexture(0) }
#break
#end
#end //#macro BeginWorld()

#macro FlatBlock(X,Y,Z)
box { <X,Y,-10>,<X+WorldBlockX,Y+WorldBlockY,Z+OFFSET_Z>
	GetGroundTexture(Z)}
#end

#macro SlideBlockX(X,Y,Z,Z2)
#local X2=X+WorldBlockX;
#local Y2=Y+WorldBlockY;
#local ZO=Z+OFFSET_Z;
#local ZO2=Z2+OFFSET_Z;
union {
 polygon {5,<X,Y,ZO>,<X2,Y,ZO2>,<X2,Y2,ZO2>,<X,Y2,ZO>,<X,Y,ZO>}
 polygon {5,<X,Y,ZO>,<X,Y2,ZO>,<X,Y2,-10>,<X,Y,-10>,<X,Y,ZO>}
 polygon {5,<X2,Y,ZO2>,<X2,Y2,ZO2>,<X2,Y2,-10>,<X2,Y,-10>,<X2,Y,ZO2>}
 polygon {5,<X,Y2,ZO>,<X2,Y2,ZO2>,<X2,Y2,-10>,<X,Y2,-10>,<X,Y2,ZO>}
 polygon {5,<X,Y,ZO>,<X2,Y,ZO2>,<X2,Y,-10>,<X,Y,-10>,<X,Y,ZO>}
  GetGroundTexture(((Z+Z2)/2)) }
#end

#macro SlideBlockY(X,Y,Z,Z2)
#local X2=X+WorldBlockX;
#local Y2=Y+WorldBlockY;
#local ZO=Z+OFFSET_Z;
#local ZO2=Z2+OFFSET_Z;
union {
 polygon {5,<X,Y,ZO>,<X2,Y,ZO>,<X2,Y2,ZO2>,<X,Y2,ZO2>,<X,Y,ZO>}
 polygon {5,<X,Y,ZO>,<X,Y2,ZO2>,<X,Y2,-10>,<X,Y,-10>,<X,Y,ZO>}
 polygon {5,<X2,Y,ZO>,<X2,Y2,ZO2>,<X2,Y2,-10>,<X2,Y,-10>,<X2,Y,ZO>}
 polygon {5,<X,Y2,ZO2>,<X2,Y2,ZO2>,<X2,Y2,-10>,<X,Y2,-10>,<X,Y2,ZO2>}
 polygon {5,<X,Y,ZO>,<X2,Y,ZO>,<X2,Y,-10>,<X,Y,-10>,<X,Y,ZO>}
  GetGroundTexture(((Z+Z2)/2)) }
#end

#macro SmoothMapNormal(i,j)
#if (i>0)
#local zly=MapData[i-1][j];
#else
#local zly=MapData[i][j];
#end
#if (j>0)
#local zlx=MapData[i][j-1];
#else
#local zlx=MapData[i][j];
#end
#if (i<ny)
#local zry=MapData[i+1][j];
#else
#local zry=MapData[i][j];
#end
#if (j<nx)
#local zrx=MapData[i][j+1];
#else
#local zrx=MapData[i][j];
#end
#local N=<(zlx-zrx)/dx,(zly-zry)/dy,2>;
vnormalize(N)
#end

/* stare!
#macro SmoothMapNormal(i,j)
#if (i>0)
#local zlx=MapData[i-1][j];
#else
#local zlx=MapData[i][j];
#end
#if (j>0)
#local zly=MapData[i][j-1];
#else
#local zly=MapData[i][j];
#end
#if (i<ny)
#local zrx=MapData[i+1][j];
#else
#local zrx=MapData[i][j];
#end
#if (j<nx)
#local zry=MapData[i][j+1];
#else
#local zry=MapData[i][j];
#end
<(zlx-zrx)/dy,(zly-zry)/dx,2>
#end
*/

#ifndef (MakeSmoothWorld)
#macro MakeSmoothWorld()
union
  {
#local i=0;
#local j=0;
#local X=0;
#local Y=0;
#local nx=dimension_size(MapData,2)-1;
#local ny=dimension_size(MapData,1)-1;
#local dx=field_World_wrldsiz/nx;
#local dy=field_World_wrldsiz/ny;

#if (HeightfieldMode<2)
mesh {
#end
  
#while (i<nx)
  #declare j=0;
  #declare Y=0;
  #while (j<ny)
    
#local Z=MapData[j][i];
#local Zx=MapData[j][i+1];
#local Zy=MapData[j+1][i];
#local Zxy=MapData[j+1][i+1];
    
#if (HeightfieldMode=0)
triangle { <X,Y,Z>,<X+dx,Y,Zx>,<X+dx,Y+dy,Zxy> }
triangle { <X,Y,Z>,<X+dx,Y+dy,Zxy>,<X,Y+dy,Zy> }
#end

#if (HeightfieldMode=1)
smooth_triangle { <X,Y,Z>,SmoothMapNormal(j,i),
		  <X+dx,Y,Zx>,SmoothMapNormal(j,i+1),
		  <X+dx,Y+dy,Zxy>,SmoothMapNormal(j+1,i+1) }
smooth_triangle { <X,Y,Z>,SmoothMapNormal(j,i),
		  <X+dx,Y+dy,Zxy>,SmoothMapNormal(j+1,i+1),
		  <X,Y+dy,Zy>,SmoothMapNormal(j+1,i) }
#end
    
#if (HeightfieldMode=2)

#local X1=X+dx/3;
#local X2=X+2*dx/3;
#local X3=X+dx;
#local Y1=Y+dy/3;
#local Y2=Y+2*dy/3;
#local Y3=Y+dy;
    
#if (i>0)
#local im=i-1;
#else
#local im=i;
#end

#if (i<(nx-1))
#local ip=i+2;
#else
#local ip=i+1;
#end

#if (j>0)
#local jm=j-1;
#else
#local jm=j;
#end

#if (j<(ny-1))
#local jp=j+2;
#else
#local jp=j+1;
#end
    
#local sx0=(Zx-MapData[j][im])/6;
#local sy0=(Zy-MapData[jm][i])/6;
#local sx1=(MapData[j][ip]-Z)/6;
#local sy1=(Zxy-MapData[jm][i+1])/6;
#local sx2=(Zxy-MapData[j+1][im])/6;
#local sy2=(MapData[jp][i]-Z)/6;
#local sx3=(MapData[j+1][ip]-Zy)/6;
#local sy3=(MapData[jp][i+1]-Zx)/6;
    
  bicubic_patch
    {
      type 1 u_steps 4 v_steps 4 flatness 0.02
        <X,Y,Z>,<X1,Y,Z+sx0>,<X2,Y,Zx-sx1>,<X3,Y,Zx>,
        <X,Y1,Z+sy0>,<X1,Y1,Z+sx0+sy0>,<X2,Y1,Zx-sx1+sy1>,<X3,Y1,Zx+sy1>,
        <X,Y2,Zy-sy2>,<X1,Y2,Zy+sx2-sy2>,<X2,Y2,Zxy-sx3-sy3>,<X3,Y2,Zxy-sy3>,
        <X,Y3,Zy>,<X1,Y3,Zy+sx2>,<X2,Y3,Zxy-sx3>,<X3,Y3,Zxy>
    }
#end // HeightfieldMode==2
  
#declare j=j+1; #declare Y=Y+dy;
#end
#declare i=i+1; #declare X=X+dx;
#end
  
#if (HeightfieldMode<2)
} //mesh
#end

difference
    {
    plane { z,0 }
    box { <0,0,1>,<field_World_wrldsiz,field_World_wrldsiz,-100> }
    }
    
    translate <0,0,OFFSET_Z>
    
texture {Ground0Texture}

  } //union
#end //#macro MakeSmoothWorld()
#end //#ifndef (MakeSmoothWorld)
  
#macro EndWorld()
#switch (field_World_wrldbnd)
#case (BORDER_FENCE)
Fence()
#break
#case (BORDER_TELEPORT)
TeleportBoundary()
#break
#end
#if (field_World_wrldtyp=WORLD_SMOOTH)
MakeSmoothWorld()
#end
#end

#include "math.inc"
// calculate camera location, to be used inside camera transform instead of the forbidden look_at
#macro LookAtRotation(dir)
  #local zdir=<dir.x,dir.y,0>;
  #local zangle=VAngleD(zdir,<0,1,0>);
  #if (dir.x<0)
    #local zangle=-zangle;
  #end
  #local dir2=vrotate(dir,<0,0,zangle>);
  #local xangle=VAngleD(dir2,<0,1,0>);
  #if (dir2.z>0)
    #local xangle=-xangle;
  #end
  <-xangle,0,-zangle>
#end
  
#macro CameraIsUnderwater()
 (CameraLocation.z < (field_World_wrldwat+OFFSET_Z))
#end
 
#declare NoCameraSet=1;
#macro Camera(Loc,LookAt)
#if (NoCameraSet)
#declare CameraLocation=Loc;
camera { StandardCamera
  rotate LookAtRotation(LookAt-Loc)
  translate Loc
  }
#declare NoCameraSet=0;
#end
#end

//////////////////////////////

#macro BeginScene()

#ifndef (SunPhase) //SunPhase=1 (default) = use LightColor and default sky colors, SunPhase=0..1 = use the built-in sunrise/set transition
 #declare SunPhase=1;
#end

#if (SunPhase<1)
 #if (SunPhase<0.5)
    #local w2=2*SunPhase;
    #local w1=1-w2;
#declare HorizonColor=HorizonColor_0*w1+HorizonColor_1*w2;
#declare MidSkyColor0=MidSkyColor0_0*w1+MidSkyColor0_1*w2;
#declare MidSkyColor1=MidSkyColor1_0*w1+MidSkyColor1_1*w2;
#declare MidSkyColor2=MidSkyColor2_0*w1+MidSkyColor2_1*w2;
#declare MidSkyColor3=MidSkyColor3_0*w1+MidSkyColor3_1*w2;
#declare HighSkyColor0=HighSkyColor0_0*w1+HighSkyColor0_1*w2;
#declare HighSkyColor1=HighSkyColor1_0*w1+HighSkyColor1_1*w2;
#declare HighSkyColor2=HighSkyColor2_0*w1+HighSkyColor2_1*w2;
#declare HighSkyColor3=HighSkyColor3_0*w1+HighSkyColor3_1*w2;
#declare LightColor=LightColor_0*w1+LightColor_1*w2;

 #else

  #local w2=2*(SunPhase-0.5);
  #local w1=1-w2;
#declare HorizonColor=HorizonColor_1*w1+HorizonColor_2*w2;
#declare MidSkyColor0=MidSkyColor0_1*w1+MidSkyColor0_2*w2;
#declare MidSkyColor1=MidSkyColor1_1*w1+MidSkyColor1_2*w2;
#declare MidSkyColor2=MidSkyColor2_1*w1+MidSkyColor2_2*w2;
#declare MidSkyColor3=MidSkyColor3_1*w1+MidSkyColor3_2*w2;
#declare HighSkyColor0=HighSkyColor0_1*w1+HighSkyColor0_2*w2;
#declare HighSkyColor1=HighSkyColor1_1*w1+HighSkyColor1_2*w2;
#declare HighSkyColor2=HighSkyColor2_1*w1+HighSkyColor2_2*w2;
#declare HighSkyColor3=HighSkyColor3_1*w1+HighSkyColor3_2*w2;
#declare LightColor=LightColor_1*w1+LightColor_2*w2;
 #end

#else // no SunPhase

#ifndef (HorizonColor)
 #declare HorizonColor=HorizonColor_2;
#end
#ifndef (MidSkyColor0)
 #declare MidSkyColor0=MidSkyColor0_2;
 #declare MidSkyColor1=MidSkyColor1_2;
 #declare MidSkyColor2=MidSkyColor2_2;
 #declare MidSkyColor3=MidSkyColor3_2;
 #declare HighSkyColor0=HighSkyColor0_2;
 #declare HighSkyColor1=HighSkyColor1_2;
 #declare HighSkyColor2=HighSkyColor2_2;
 #declare HighSkyColor3=HighSkyColor3_2;
 #declare LightColor=LightColor_2;
#end

#end

StandardSky()
StandardLight()
  
BeginEnergy()

#if (!CameraIsUnderwater())
  #declare FogAlt=max(field_World_wrldwat,0)+5+OFFSET_Z;
  fog { color rgb HorizonColor distance 200  fog_type 2  fog_offset FogAlt fog_alt 5 rotate <90,0,0> }
#end

#if ((field_World_wrldwat>0) | (field_World_wrldtyp != WORLD_FLAT))
// polygon {5, <-999,-999,0>,<999,-999,0>,<999,999,0>,<-999,999,0>,<-999,-999,0>
  
 plane { z,0
  WaterTexture()
  interior { WaterInterior }
	translate <0,0,field_World_wrldwat+OFFSET_Z> 
  hollow
  }

#if (CameraIsUnderwater())

 fog { color WaterFogColor
   distance WaterFogDistance
	fog_type 2
	fog_offset field_World_wrldwat+OFFSET_Z-3
	fog_alt 2
	rotate <90,0,0>
	}
#end
  
#end //Water
  
#end //#macro BeginScene()

#macro EndScene()
EndEnergy()
#ifdef(EndSceneExtra)
 EndSceneExtra()
#end
#end

#macro BeginObject()
#declare PartAssimTab=array[field_Creature_numparts]
#end

#macro EndObject()
#end

#macro BeginPart(Id)
#declare St_Recept_S=0;
#declare St_Recept_T=0;
#declare CreatePartAtEnd=1;
#declare PartAssimTab[Id]=field_p_as;
#end
  
#macro PartGeometryStd(Location,Rotation)
 #if (!strcmp(field_m_Vstyle,"food"))
  Energy(Location,1.0)
  #declare CreatePartAtEnd=0;
 #end
 #if (!strcmp(field_m_Vstyle,"manipulator"))
  Manipulator(Location,0.0)
  #declare CreatePartAtEnd=0;
 #end
 #ifndef (field_p_sh)
  #declare field_p_sh=0;
 #end
 #switch (field_p_sh)
  #case (1)
   #if (!strcmp(field_m_Vstyle,"foram"))
    ForamShape(Location,Rotation)
   #else
    EllipsoidShape(Location,Rotation)
   #end
   #declare CreatePartAtEnd=0;
  #break
  #case (2)
   CuboidShape(Location,Rotation)
   #declare CreatePartAtEnd=0;
  #break
  #case (3)
   CylinderShape(Location,Rotation)
   #declare CreatePartAtEnd=0;
  #break
 #end
 #declare StickEndLoc=Location;
 #declare StickEndRot=Rotation;
#end

#ifndef (PartGeometry)
#macro PartGeometry(Location,Rotation)
  PartGeometryStd(Location,Rotation)
#end
#end
  
#macro EndPart()
#if (CreatePartAtEnd)
CreatureStickEnd(StickEndLoc,StickEndRot)
#end
#end

#macro BeginJoint(Part1,Part2)
#declare St_Recept_G=0;
#declare St_BendMuscle=0;
#declare St_RotMuscle=0;
#declare St_Asimil=(PartAssimTab[Part1]+PartAssimTab[Part2])/2.0;
#end

#macro JointGeometry(Location1,Location2,Rotation)
#declare StickLoc1=Location1;
#declare StickLoc2=Location2;
#declare StickRot=Rotation;
#end

#macro EndJoint()
#declare St_Speed=0.5;
#ifndef (field_j_sh)
 #declare field_j_sh=0;
#end
#if (field_j_sh=0)
 CreatureStick(StickLoc1,StickLoc2,StickRot)
#end
#end

#macro BeginNeuro(NClass)
 #if (!strcmp(NClass,"|"))
  #declare St_BendMuscle=1;
  #declare St_BendMusclePos=field_n_s*3.14;
 #end
 #if (!strcmp(NClass,"@"))
  #declare St_RotMuscle=1;
 #end
 #if (!strcmp(NClass,"G"))
  #declare St_Recept_G=1;
 #end
 #if (!strcmp(NClass,"S"))
  #declare St_Recept_S=1;
 #end
 #if (!strcmp(NClass,"T"))
  #declare St_Recept_T=1;
 #end
#end

#macro EndNeuro()
#end
