//standard selection methods

// new style: do not use global state (selected group index) in GenePools, return Genotype object

function selectedForDeletionInPool(pool)
{
  if (ExpParams.delrule == 0)
    return pool.random();
  if (ExpParams.delrule == 1)
    return pool.revroulette();
  return pool.worst();
}

function selectedForCreationInPool(pool)
{
  if (ExpParams.selrule == 0)
    return pool.random();
  if (ExpParams.selrule == 1)
    return pool.roulette();
  return pool.tournament(ExpParams.selrule);
}

function selectedSimilarInPool(pool,genotype)
{
  if (ExpParams.selrule == 0)
    return pool.randomLikeGenotype(ExpParams.xov_mins,genotype);
  else
    return pool.rouletteLikeGenotype(ExpParams.xov_mins,genotype);
}

// for compatiblity with old scripts - do not use: these functions will be eventually removed!

function selectedForDeletion()
{
  if (ExpParams.delrule == 0)
    return GenePools.random();
  if (ExpParams.delrule == 1)
    return GenePools.revroulette();
  return GenePools.worst();
}

function selectedForCreation()
{
  if (ExpParams.selrule == 0)
    return GenePools.random();
  if (ExpParams.selrule == 1)
    return GenePools.roulette();
  return GenePools.tournament(ExpParams.selrule);
}

function selectedSimilar()
{
  if (ExpParams.selrule == 0)
    return GenePools.randomLikeThis(ExpParams.xov_mins);
  else
    return GenePools.likeThisRoulette(ExpParams.xov_mins);
}

